/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils;

import android.content.Context;
import android.net.Uri;
import com.MAVLink.common.msg_mission_item;
import com.o3dr.services.android.lib.drone.mission.Mission;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.util.ParcelableUtils;
import com.o3dr.services.android.lib.util.UriUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.commands.CameraTriggerImpl;
import org.droidplanner.services.android.impl.core.mission.commands.ChangeSpeedImpl;
import org.droidplanner.services.android.impl.core.mission.commands.ConditionYawImpl;
import org.droidplanner.services.android.impl.core.mission.commands.DoJumpImpl;
import org.droidplanner.services.android.impl.core.mission.commands.EpmGripperImpl;
import org.droidplanner.services.android.impl.core.mission.commands.ReturnToHomeImpl;
import org.droidplanner.services.android.impl.core.mission.commands.SetRelayImpl;
import org.droidplanner.services.android.impl.core.mission.commands.SetServoImpl;
import org.droidplanner.services.android.impl.core.mission.commands.TakeoffImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.CircleImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.DoLandStartImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.LandImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.RegionOfInterestImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.SplineWaypointImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.WaypointImpl;
import org.droidplanner.services.android.impl.utils.CommonApiUtils;
import org.droidplanner.services.android.impl.utils.ProxyUtils;
import timber.log.Timber;

public class MissionUtils {
    private static final String WAYPOINT_PROTOCOL_HEADER = "QGC WPL 110";

    private MissionUtils() {
    }

    public static void saveMission(Context context, Mission mission, Uri saveUri, ICommandListener listener) {
        MissionUtils.saveMissionToWPL(context, mission, saveUri, listener);
    }

    public static Mission loadMission(Context context, Uri loadUri) {
        Mission mission = MissionUtils.loadMissionFromWPL(context, loadUri);
        if (mission == null) {
            mission = MissionUtils.loadMissionFromDpwp(context, loadUri);
        }
        return mission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveMissionToWPL(Context context, Mission mission, Uri saveUri, ICommandListener listener) {
        try (OutputStream saveOut = UriUtils.getOutputStream(context, saveUri);){
            String header = "QGC WPL 110\n";
            saveOut.write(header.getBytes());
            List<msg_mission_item> rawMissionItems = MissionUtils.fromMission(mission);
            int msgMissionItemsSize = rawMissionItems.size();
            for (int i = 0; i < msgMissionItemsSize; ++i) {
                msg_mission_item msg = rawMissionItems.get(i);
                saveOut.write(String.format(Locale.ENGLISH, "%d\t%d\t%d\t%d\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%d\n", i, i == 0 ? 1 : 0, msg.frame, msg.command, Float.valueOf(msg.param1), Float.valueOf(msg.param2), Float.valueOf(msg.param3), Float.valueOf(msg.param4), Float.valueOf(msg.x), Float.valueOf(msg.y), Float.valueOf(msg.z), msg.autocontinue).getBytes());
            }
            CommonApiUtils.postSuccessEvent(listener);
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Unable to write to uri %s", (Object[])new Object[]{saveUri});
            CommonApiUtils.postErrorEvent(4, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveMissionToDpwp(Context context, Mission mission, Uri saveUri, ICommandListener listener) {
        try (OutputStream saveOut = UriUtils.getOutputStream(context, saveUri);){
            byte[] missionBytes = ParcelableUtils.marshall(mission);
            saveOut.write(missionBytes);
            CommonApiUtils.postSuccessEvent(listener);
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Unable to write to uri %s", (Object[])new Object[]{saveUri});
            CommonApiUtils.postErrorEvent(4, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mission loadMissionFromDpwp(Context context, Uri loadUri) {
        Mission mission;
        InputStream loadIn = UriUtils.getInputStream(context, loadUri);
        try {
            Mission mission2;
            LinkedHashMap<byte[], Integer> bytesList = new LinkedHashMap<byte[], Integer>();
            int length = 0;
            while (loadIn.available() > 0) {
                byte[] missionBytes = new byte[2048];
                int bufferSize = loadIn.read(missionBytes);
                bytesList.put(missionBytes, bufferSize);
                length += bufferSize;
            }
            ByteBuffer fullBuffer = ByteBuffer.allocate(length);
            for (Map.Entry entry : bytesList.entrySet()) {
                fullBuffer.put((byte[])entry.getKey(), 0, (Integer)entry.getValue());
            }
            mission = mission2 = ParcelableUtils.unmarshall(fullBuffer.array(), 0, length, Mission.CREATOR);
        }
        catch (Throwable throwable) {
            try {
                loadIn.close();
                throw throwable;
            }
            catch (IOException e) {
                Timber.e((Throwable)e, (String)"Unable to read from uri %s", (Object[])new Object[]{loadUri});
                return null;
            }
        }
        loadIn.close();
        return mission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Mission loadMissionFromWPL(Context context, Uri loadUri) {
        try (InputStream loadIn = UriUtils.getInputStream(context, loadUri);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(loadIn));
            if (!reader.readLine().contains(WAYPOINT_PROTOCOL_HEADER)) {
                Timber.w((String)"Invalid waypoint file format for %s", (Object[])new Object[]{loadUri});
                Mission mission = null;
                return mission;
            }
            LinkedList<msg_mission_item> rawMissionItems = new LinkedList<msg_mission_item>();
            while ((line = reader.readLine()) != null) {
                String[] rowData = line.split("\t");
                msg_mission_item msg = new msg_mission_item();
                msg.seq = Short.parseShort(rowData[0]);
                msg.current = Byte.parseByte(rowData[1]);
                msg.frame = Byte.parseByte(rowData[2]);
                msg.command = Short.parseShort(rowData[3]);
                msg.param1 = Float.parseFloat(rowData[4]);
                msg.param2 = Float.parseFloat(rowData[5]);
                msg.param3 = Float.parseFloat(rowData[6]);
                msg.param4 = Float.parseFloat(rowData[7]);
                msg.x = Float.parseFloat(rowData[8]);
                msg.y = Float.parseFloat(rowData[9]);
                msg.z = Float.parseFloat(rowData[10]);
                msg.autocontinue = Byte.parseByte(rowData[11]);
                rawMissionItems.add(msg);
            }
            Mission mission = MissionUtils.fromRawMissionItems(rawMissionItems);
            return mission;
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Unable to load mission from uri %s", (Object[])new Object[]{loadUri});
            return null;
        }
    }

    private static List<msg_mission_item> fromMission(Mission mission) {
        if (mission == null) {
            return null;
        }
        List<MissionItem> missionItems = mission.getMissionItems();
        if (missionItems.isEmpty()) {
            return Collections.emptyList();
        }
        MissionImpl missionImpl = new MissionImpl(null);
        ArrayList<msg_mission_item> rawMissionItems = new ArrayList<msg_mission_item>(missionItems.size());
        for (MissionItem missionItem : missionItems) {
            MissionItemImpl impl = ProxyUtils.getMissionItemImpl(missionImpl, missionItem);
            rawMissionItems.addAll(impl.packMissionItem());
        }
        return rawMissionItems;
    }

    private static Mission fromRawMissionItems(List<msg_mission_item> rawMissionItems) {
        Mission mission = new Mission();
        if (rawMissionItems == null || rawMissionItems.isEmpty()) {
            return mission;
        }
        List<MissionItemImpl> impls = MissionUtils.processMavLinkMessages(new MissionImpl(null), rawMissionItems);
        if (!impls.isEmpty()) {
            for (MissionItemImpl impl : impls) {
                MissionItem missionItem = ProxyUtils.getProxyMissionItem(impl);
                if (missionItem == null) continue;
                mission.addMissionItem(missionItem);
            }
        }
        return mission;
    }

    public static List<MissionItemImpl> processMavLinkMessages(MissionImpl missionImpl, List<msg_mission_item> msgs) {
        ArrayList<MissionItemImpl> received = new ArrayList<MissionItemImpl>();
        for (msg_mission_item msg : msgs) {
            switch (msg.command) {
                case 183: {
                    received.add(new SetServoImpl(msg, missionImpl));
                    break;
                }
                case 16: {
                    received.add(new WaypointImpl(msg, missionImpl));
                    break;
                }
                case 82: {
                    received.add(new SplineWaypointImpl(msg, missionImpl));
                    break;
                }
                case 21: {
                    received.add(new LandImpl(msg, missionImpl));
                    break;
                }
                case 189: {
                    received.add(new DoLandStartImpl(msg, missionImpl));
                    break;
                }
                case 22: {
                    received.add(new TakeoffImpl(msg, missionImpl));
                    break;
                }
                case 178: {
                    received.add(new ChangeSpeedImpl(msg, missionImpl));
                    break;
                }
                case 206: {
                    received.add(new CameraTriggerImpl(msg, missionImpl));
                    break;
                }
                case 211: {
                    received.add(new EpmGripperImpl(msg, missionImpl));
                    break;
                }
                case 201: {
                    received.add(new RegionOfInterestImpl(msg, missionImpl));
                    break;
                }
                case 18: {
                    received.add(new CircleImpl(msg, missionImpl));
                    break;
                }
                case 20: {
                    received.add(new ReturnToHomeImpl(msg, missionImpl));
                    break;
                }
                case 115: {
                    received.add(new ConditionYawImpl(msg, missionImpl));
                    break;
                }
                case 181: {
                    received.add(new SetRelayImpl(msg, missionImpl));
                    break;
                }
                case 177: {
                    received.add(new DoJumpImpl(msg, missionImpl));
                    break;
                }
            }
        }
        return received;
    }
}

