/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.geoTools.spline;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.spline.Spline;

public class SplinePath {
    private static final String TAG = SplinePath.class.getSimpleName();
    private static final int SPLINE_DECIMATION = 20;

    public static List<LatLong> process(List<LatLong> points) {
        int pointsCount = points.size();
        if (pointsCount < 4) {
            System.err.println("Not enough points!");
            return points;
        }
        List<LatLong> results = SplinePath.processPath(points);
        results.add(0, points.get(0));
        results.add(points.get(pointsCount - 1));
        return results;
    }

    private static List<LatLong> processPath(List<LatLong> points) {
        ArrayList<LatLong> results = new ArrayList<LatLong>();
        for (int i = 3; i < points.size(); ++i) {
            results.addAll(SplinePath.processPathSegment(points.get(i - 3), points.get(i - 2), points.get(i - 1), points.get(i)));
        }
        return results;
    }

    private static List<LatLong> processPathSegment(LatLong l1, LatLong l2, LatLong l3, LatLong l4) {
        Spline spline = new Spline(l1, l2, l3, l4);
        return spline.generateCoordinates(20);
    }
}

