/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.roi;

import android.os.Handler;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import java.util.concurrent.atomic.AtomicBoolean;
import org.droidplanner.services.android.impl.core.MAVLink.command.doCmd.MavLinkDoCmds;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class ROIEstimator
implements Location.LocationReceiver {
    private static final int TIMEOUT = 100;
    protected Location realLocation;
    protected long timeOfLastLocation;
    protected final MavLinkDrone drone;
    protected Handler watchdog;
    protected Runnable watchdogCallback = new Runnable(){

        @Override
        public void run() {
            ROIEstimator.this.updateROI();
        }
    };
    protected final AtomicBoolean isFollowEnabled = new AtomicBoolean(false);

    public ROIEstimator(MavLinkDrone drone, Handler handler) {
        this.watchdog = handler;
        this.drone = drone;
    }

    public void enableFollow() {
        MavLinkDoCmds.resetROI(this.drone, null);
        this.isFollowEnabled.set(true);
    }

    public void disableFollow() {
        if (this.isFollowEnabled.compareAndSet(true, false)) {
            this.realLocation = null;
            MavLinkDoCmds.resetROI(this.drone, null);
            this.disableWatchdog();
        }
    }

    @Override
    public final void onLocationUpdate(Location location) {
        if (!this.isFollowEnabled.get()) {
            return;
        }
        this.realLocation = location;
        this.timeOfLastLocation = System.currentTimeMillis();
        this.disableWatchdog();
        this.updateROI();
    }

    @Override
    public void onLocationUnavailable() {
        this.disableWatchdog();
    }

    protected void disableWatchdog() {
        this.watchdog.removeCallbacks(this.watchdogCallback);
    }

    protected void updateROI() {
        if (this.realLocation == null) {
            return;
        }
        LatLongAlt gcsCoord = this.realLocation.getCoord();
        double bearing = this.realLocation.getBearing();
        double distanceTraveledSinceLastPoint = this.realLocation.getSpeed() * (double)(System.currentTimeMillis() - this.timeOfLastLocation) / 1000.0;
        LatLong goCoord = GeoTools.newCoordFromBearingAndDistance(gcsCoord, bearing, distanceTraveledSinceLastPoint);
        this.sendUpdateROI(goCoord);
        if (this.realLocation.getSpeed() > 0.0) {
            this.watchdog.postDelayed(this.watchdogCallback, this.getUpdatePeriod());
        }
    }

    protected void sendUpdateROI(LatLong goCoord) {
        MavLinkDoCmds.setROI(this.drone, new LatLongAlt(goCoord.getLatitude(), goCoord.getLongitude(), 0.0), null);
    }

    public boolean isFollowEnabled() {
        return this.isFollowEnabled.get();
    }

    protected long getUpdatePeriod() {
        return 100L;
    }
}

