/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import com.o3dr.services.android.lib.coordinate.LatLong;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowWithRadiusAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public abstract class FollowHeadingAngle
extends FollowWithRadiusAlgorithm {
    protected double angleOffset;
    protected final MavLinkDrone drone;

    protected FollowHeadingAngle(MavLinkDroneManager droneMgr, Handler handler, double radius, double angleOffset) {
        super(droneMgr, handler, radius);
        this.angleOffset = angleOffset;
        this.drone = (MavLinkDrone)droneMgr.getDrone();
    }

    @Override
    public void processNewLocation(Location location) {
        LatLong gcsCoord = new LatLong(location.getCoord());
        double bearing = location.getBearing();
        LatLong goCoord = GeoTools.newCoordFromBearingAndDistance(gcsCoord, bearing + this.angleOffset, this.radius);
        this.drone.getGuidedPoint().newGuidedCoord(goCoord);
    }
}

