/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import com.MAVLink.ardupilotmega.msg_camera_feedback;
import com.MAVLink.ardupilotmega.msg_mount_status;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.drone.property.Altitude;
import com.o3dr.services.android.lib.drone.property.Attitude;
import com.o3dr.services.android.lib.drone.property.Gps;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;
import org.droidplanner.services.android.impl.core.survey.Footprint;

public class Camera
extends DroneVariable {
    private CameraInfo camera = new CameraInfo();
    private List<Footprint> footprints = new ArrayList<Footprint>();
    private double gimbal_pitch;

    public Camera(MavLinkDrone myDrone) {
        super(myDrone);
    }

    public void newImageLocation(msg_camera_feedback msg) {
        this.footprints.add(new Footprint(this.camera, msg));
        this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.FOOTPRINT);
    }

    public List<Footprint> getFootprints() {
        return this.footprints;
    }

    public Footprint getLastFootprint() {
        return this.footprints.get(this.footprints.size() - 1);
    }

    public CameraInfo getCamera() {
        return this.camera;
    }

    public Footprint getCurrentFieldOfView() {
        Altitude droneAltitude = (Altitude)this.myDrone.getAttribute("com.o3dr.services.android.lib.attribute.ALTITUDE");
        double altitude = droneAltitude.getAltitude();
        Gps droneGps = (Gps)this.myDrone.getAttribute("com.o3dr.services.android.lib.attribute.GPS");
        LatLong position = droneGps.getPosition();
        Attitude attitude = (Attitude)this.myDrone.getAttribute("com.o3dr.services.android.lib.attribute.ATTITUDE");
        double pitch = attitude.getPitch();
        double roll = attitude.getRoll();
        double yaw = attitude.getYaw();
        return new Footprint(this.camera, position, altitude, pitch, roll, yaw);
    }

    public void updateMountOrientation(msg_mount_status msg_mount_status2) {
        this.gimbal_pitch = 90 - msg_mount_status2.pointing_a / 100;
    }
}

