/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import java.util.ArrayList;
import java.util.List;

public enum ApmModes {
    FIXED_WING_MANUAL(0L, "Manual", 1),
    FIXED_WING_CIRCLE(1L, "Circle", 1),
    FIXED_WING_STABILIZE(2L, "Stabilize", 1),
    FIXED_WING_TRAINING(3L, "Training", 1),
    FIXED_WING_ACRO(4L, "Acro", 1),
    FIXED_WING_FLY_BY_WIRE_A(5L, "FBW A", 1),
    FIXED_WING_FLY_BY_WIRE_B(6L, "FBW B", 1),
    FIXED_WING_CRUISE(7L, "Cruise", 1),
    FIXED_WING_AUTOTUNE(8L, "AutoTune", 1),
    FIXED_WING_AUTO(10L, "Auto", 1),
    FIXED_WING_RTL(11L, "RTL", 1),
    FIXED_WING_LOITER(12L, "Loiter", 1),
    FIXED_WING_GUIDED(15L, "Guided", 1),
    ROTOR_STABILIZE(0L, "Stabilize", 2),
    ROTOR_ACRO(1L, "Acro", 2),
    ROTOR_ALT_HOLD(2L, "Alt Hold", 2),
    ROTOR_AUTO(3L, "Auto", 2),
    ROTOR_GUIDED(4L, "Guided", 2),
    ROTOR_LOITER(5L, "Loiter", 2),
    ROTOR_RTL(6L, "RTL", 2),
    ROTOR_CIRCLE(7L, "Circle", 2),
    ROTOR_LAND(9L, "Land", 2),
    ROTOR_TOY(11L, "Drift", 2),
    ROTOR_SPORT(13L, "Sport", 2),
    ROTOR_AUTOTUNE(15L, "Autotune", 2),
    ROTOR_POSHOLD(16L, "PosHold", 2),
    ROTOR_BRAKE(17L, "Brake", 2),
    ROVER_MANUAL(0L, "MANUAL", 10),
    ROVER_LEARNING(2L, "LEARNING", 10),
    ROVER_STEERING(3L, "STEERING", 10),
    ROVER_HOLD(4L, "HOLD", 10),
    ROVER_AUTO(10L, "AUTO", 10),
    ROVER_RTL(11L, "RTL", 10),
    ROVER_GUIDED(15L, "GUIDED", 10),
    ROVER_INITIALIZING(16L, "INITIALIZING", 10),
    UNKNOWN(-1L, "Unknown", 0);

    private final long number;
    private final String name;
    private final int type;

    private ApmModes(long number, String name, int type) {
        this.number = number;
        this.name = name;
        this.type = type;
    }

    public long getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public static ApmModes getMode(long i, int type) {
        if (ApmModes.isCopter(type)) {
            type = 2;
        }
        for (ApmModes mode : ApmModes.values()) {
            if (i != mode.getNumber() || type != mode.getType()) continue;
            return mode;
        }
        return UNKNOWN;
    }

    public static ApmModes getMode(String str, int type) {
        if (ApmModes.isCopter(type)) {
            type = 2;
        }
        for (ApmModes mode : ApmModes.values()) {
            if (!str.equals(mode.getName()) || type != mode.getType()) continue;
            return mode;
        }
        return UNKNOWN;
    }

    public static List<ApmModes> getModeList(int type) {
        ArrayList<ApmModes> modeList = new ArrayList<ApmModes>();
        if (ApmModes.isCopter(type)) {
            type = 2;
        }
        for (ApmModes mode : ApmModes.values()) {
            if (mode.getType() != type) continue;
            modeList.add(mode);
        }
        return modeList;
    }

    public static boolean isValid(ApmModes mode) {
        return mode != UNKNOWN;
    }

    public static boolean isCopter(int type) {
        switch (type) {
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }
}

