/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm;

import android.content.Context;
import android.os.Handler;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_global_position_int;
import com.MAVLink.common.msg_vfr_hud;
import com.github.zafarkhaja.semver.Version;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.drone.LogMessageListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.ArduPilot;
import org.droidplanner.services.android.impl.core.firmware.FirmwareType;
import org.droidplanner.services.android.impl.core.model.AutopilotWarningParser;

public class ArduPlane
extends ArduPilot {
    private static final Version ARDU_PLANE_V3_3 = Version.forIntegers((int)3, (int)3, (int)0);
    private static final Version ARDU_PLANE_V3_4;
    private static final Version COMPASS_CALIBRATION_MIN_VERSION;

    public ArduPlane(String droneId, Context context, DataLink.DataLinkProvider<MAVLinkMessage> mavClient, Handler handler, AutopilotWarningParser warningParser, LogMessageListener logListener) {
        super(droneId, context, mavClient, handler, warningParser, logListener);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    protected void setType(int type) {
    }

    @Override
    public FirmwareType getFirmwareType() {
        return FirmwareType.ARDU_PLANE;
    }

    @Override
    protected void processVfrHud(msg_vfr_hud vfrHud) {
    }

    @Override
    protected void processGlobalPositionInt(msg_global_position_int gpi) {
        if (gpi == null) {
            return;
        }
        super.processGlobalPositionInt(gpi);
        double relativeAlt = (double)gpi.relative_alt / 1000.0;
        double groundSpeedX = (double)gpi.vx / 100.0;
        double groundSpeedY = (double)gpi.vy / 100.0;
        double groundSpeed = Math.sqrt(Math.pow(groundSpeedX, 2.0) + Math.pow(groundSpeedY, 2.0));
        double climbRate = (double)gpi.vz / 100.0;
        this.setAltitudeGroundAndAirSpeeds(relativeAlt, groundSpeed, groundSpeed, climbRate);
    }

    @Override
    protected boolean isFeatureSupported(String featureId) {
        switch (featureId) {
            case "feature_compass_calibration": {
                return this.getFirmwareVersionNumber().greaterThanOrEqualTo(COMPASS_CALIBRATION_MIN_VERSION);
            }
        }
        return super.isFeatureSupported(featureId);
    }

    static {
        COMPASS_CALIBRATION_MIN_VERSION = ARDU_PLANE_V3_4 = Version.forIntegers((int)3, (int)4, (int)0);
    }
}

