/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class DroneEvents
extends DroneVariable<MavLinkDrone> {
    private final ConcurrentLinkedQueue<DroneInterfaces.OnDroneListener> droneListeners = new ConcurrentLinkedQueue();

    public DroneEvents(MavLinkDrone myDrone) {
        super(myDrone);
    }

    public void addDroneListener(DroneInterfaces.OnDroneListener listener) {
        if (listener != null & !this.droneListeners.contains(listener)) {
            this.droneListeners.add(listener);
        }
    }

    public void removeDroneListener(DroneInterfaces.OnDroneListener listener) {
        if (listener != null && this.droneListeners.contains(listener)) {
            this.droneListeners.remove(listener);
        }
    }

    public void removeAllDroneListeners() {
        this.droneListeners.clear();
    }

    public void notifyDroneEvent(DroneInterfaces.DroneEventsType event) {
        if (event == null || this.droneListeners.isEmpty()) {
            return;
        }
        for (DroneInterfaces.OnDroneListener listener : this.droneListeners) {
            listener.onDroneEvent(event, this.myDrone);
        }
    }
}

