/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.communication.connection.usb;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.communication.connection.usb.UsbConnection;

class UsbFTDIConnection
extends UsbConnection.UsbConnectionImpl {
    private static final String TAG = UsbFTDIConnection.class.getSimpleName();
    private static final byte LATENCY_TIMER = 32;
    private final AtomicReference<FT_Device> ftDevRef = new AtomicReference();

    protected UsbFTDIConnection(Context context, UsbConnection parentConn, int baudRate) {
        super(context, parentConn, baudRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openUsbConnection(Bundle extras) throws IOException {
        FT_Device ftDev;
        block10: {
            D2xxManager ftD2xx = null;
            try {
                ftD2xx = D2xxManager.getInstance((Context)this.mContext);
            }
            catch (D2xxManager.D2xxException ex) {
                this.mLogger.logErr(TAG, (Exception)((Object)ex));
            }
            if (ftD2xx == null) {
                throw new IOException("Unable to retrieve D2xxManager instance.");
            }
            int DevCount = ftD2xx.createDeviceInfoList(this.mContext);
            Log.d((String)TAG, (String)("Found " + DevCount + " ftdi devices."));
            if (DevCount < 1) {
                throw new IOException("No Devices found");
            }
            ftDev = null;
            try {
                ftDev = ftD2xx.openByIndex(this.mContext, 0);
            }
            catch (NullPointerException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
            finally {
                if (ftDev != null) break block10;
                throw new IOException("No Devices found");
            }
        }
        Log.d((String)TAG, (String)("Opening using Baud rate " + this.mBaudRate));
        ftDev.setBitMode((byte)0, (byte)0);
        ftDev.setBaudRate(this.mBaudRate);
        ftDev.setDataCharacteristics((byte)8, (byte)0, (byte)0);
        ftDev.setFlowControl((short)0, (byte)0, (byte)0);
        ftDev.setLatencyTimer((byte)32);
        ftDev.purge((byte)3);
        if (!ftDev.isOpen()) {
            throw new IOException("Unable to open usb device connection.");
        }
        Log.d((String)TAG, (String)"COM open");
        this.ftDevRef.set(ftDev);
        this.onUsbConnectionOpened(extras);
    }

    @Override
    protected int readDataBlock(byte[] readData) throws IOException {
        FT_Device ftDev = this.ftDevRef.get();
        if (ftDev == null || !ftDev.isOpen()) {
            throw new IOException("Device is unavailable.");
        }
        int iavailable = ftDev.getQueueStatus();
        if (iavailable > 0) {
            if (iavailable > 4096) {
                iavailable = 4096;
            }
            try {
                ftDev.read(readData, iavailable);
            }
            catch (NullPointerException e) {
                String errorMsg = "Error Reading: " + e.getMessage() + "\nAssuming inaccessible USB device.  Closing connection.";
                Log.e((String)TAG, (String)errorMsg, (Throwable)e);
                throw new IOException(errorMsg, e);
            }
        }
        if (iavailable == 0) {
            iavailable = -1;
        }
        return iavailable;
    }

    @Override
    protected void sendBuffer(byte[] buffer) {
        FT_Device ftDev = this.ftDevRef.get();
        if (ftDev != null && ftDev.isOpen()) {
            try {
                ftDev.write(buffer);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error Sending: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    protected void closeUsbConnection() throws IOException {
        FT_Device ftDev = this.ftDevRef.getAndSet(null);
        if (ftDev != null) {
            try {
                ftDev.close();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return TAG;
    }
}

