/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.communication.connection;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.droidplanner.services.android.impl.communication.connection.AndroidIpConnection;
import org.droidplanner.services.android.impl.core.MAVLink.connection.UdpConnection;
import org.droidplanner.services.android.impl.core.model.Logger;
import org.droidplanner.services.android.impl.utils.connection.WifiConnectionHandler;

public class AndroidUdpConnection
extends AndroidIpConnection {
    private static final String TAG = AndroidUdpConnection.class.getSimpleName();
    private final HashSet<PingTask> pingTasks = new HashSet();
    private final UdpConnection mConnectionImpl;
    private final int serverPort;
    private ScheduledExecutorService pingRunner;

    public AndroidUdpConnection(Context context, int udpServerPort, WifiConnectionHandler wifiHandler) {
        super(context, wifiHandler);
        this.serverPort = udpServerPort;
        this.mConnectionImpl = new UdpConnection(context){

            @Override
            protected int loadServerPort() {
                return AndroidUdpConnection.this.serverPort;
            }

            @Override
            protected Logger initLogger() {
                return AndroidUdpConnection.this.initLogger();
            }

            @Override
            protected void onConnectionOpened(Bundle extras) {
                AndroidUdpConnection.this.onConnectionOpened(extras);
            }

            @Override
            protected void onConnectionStatus(LinkConnectionStatus connectionStatus) {
                AndroidUdpConnection.this.onConnectionStatus(connectionStatus);
            }
        };
    }

    public AndroidUdpConnection(Context context, int udpServerPort) {
        this(context, udpServerPort, null);
    }

    public void addPingTarget(InetAddress address, int port, long period, byte[] payload) {
        if (address == null || payload == null || period <= 0L) {
            return;
        }
        PingTask pingTask = new PingTask(address, port, period, payload);
        this.pingTasks.add(pingTask);
        if (this.getConnectionStatus() == 2 && this.pingRunner != null && !this.pingRunner.isShutdown()) {
            this.pingRunner.scheduleWithFixedDelay(pingTask, 0L, period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void onCloseConnection() throws IOException {
        Log.d((String)TAG, (String)"Closing udp connection.");
        if (this.pingRunner != null) {
            Log.d((String)TAG, (String)"Shutting down pinging tasks.");
            this.pingRunner.shutdownNow();
            this.pingRunner = null;
        }
        this.mConnectionImpl.closeConnection();
    }

    @Override
    protected void loadPreferences() {
        this.mConnectionImpl.loadPreferences();
    }

    @Override
    protected void onOpenConnection(Bundle extras) throws IOException {
        Log.d((String)TAG, (String)"Opening udp connection");
        this.mConnectionImpl.openConnection(extras);
        if (this.pingRunner == null || this.pingRunner.isShutdown()) {
            this.pingRunner = Executors.newSingleThreadScheduledExecutor();
        }
        for (PingTask pingTask : this.pingTasks) {
            this.pingRunner.scheduleWithFixedDelay(pingTask, 0L, pingTask.period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected int readDataBlock(byte[] buffer) throws IOException {
        return this.mConnectionImpl.readDataBlock(buffer);
    }

    @Override
    protected void sendBuffer(byte[] buffer) throws IOException {
        this.mConnectionImpl.sendBuffer(buffer);
    }

    @Override
    public int getConnectionType() {
        return this.mConnectionImpl.getConnectionType();
    }

    private class PingTask
    implements Runnable {
        private final InetAddress address;
        private final int port;
        private final long period;
        private final byte[] payload;

        private PingTask(InetAddress address, int port, long period, byte[] payload) {
            this.address = address;
            this.port = port;
            this.period = period;
            this.payload = payload;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PingTask)) {
                return false;
            }
            PingTask that = (PingTask)other;
            return this.address.equals(that.address) && this.port == that.port && this.period == that.period;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public void run() {
            try {
                AndroidUdpConnection.this.mConnectionImpl.sendBuffer(this.address, this.port, this.payload);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error occurred while sending ping message.", (Throwable)e);
            }
        }

        public String toString() {
            return "[" + this.address.toString() + "; " + this.port + "; " + this.period + "]";
        }
    }
}

