/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.api;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import android.view.Surface;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.ardupilotmega.msg_mag_cal_progress;
import com.MAVLink.ardupilotmega.msg_mag_cal_report;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.drone.mission.Mission;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.mission.item.command.ResetROI;
import com.o3dr.services.android.lib.drone.mission.item.spatial.RegionOfInterest;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.Parameter;
import com.o3dr.services.android.lib.drone.property.State;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import com.o3dr.services.android.lib.mavlink.MavlinkMessageWrapper;
import com.o3dr.services.android.lib.model.IApiListener;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.IDroneApi;
import com.o3dr.services.android.lib.model.IMavlinkObserver;
import com.o3dr.services.android.lib.model.IObserver;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.droidplanner.services.android.impl.api.DroidPlannerService;
import org.droidplanner.services.android.impl.communication.connection.SoloConnection;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneManager;
import org.droidplanner.services.android.impl.core.drone.autopilot.Drone;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.variables.calibration.AccelCalibration;
import org.droidplanner.services.android.impl.core.drone.variables.calibration.MagnetometerCalibrationImpl;
import org.droidplanner.services.android.impl.exception.ConnectionException;
import org.droidplanner.services.android.impl.utils.CommonApiUtils;
import org.droidplanner.services.android.impl.utils.MissionUtils;
import timber.log.Timber;

public final class DroneApi
extends IDroneApi.Stub
implements DroneInterfaces.OnDroneListener,
DroneInterfaces.AttributeEventListener,
DroneInterfaces.OnParameterManagerListener,
MagnetometerCalibrationImpl.OnMagnetometerCalibrationListener,
IBinder.DeathRecipient {
    private static final int RESET_ROI_LIB_VERSION = 206080;
    private final Runnable eventsDispatcher = new Runnable(){
        private final LinkedHashMap<String, Bundle> eventsFilter = new LinkedHashMap();

        @Override
        public void run() {
            this.eventsFilter.clear();
            EventInfo eventInfo = (EventInfo)DroneApi.this.eventsBuffer.poll();
            while (eventInfo != null) {
                this.eventsFilter.put(eventInfo.event, eventInfo.extras);
                EventInfo.recycle(eventInfo);
                eventInfo = (EventInfo)DroneApi.this.eventsBuffer.poll();
            }
            for (Map.Entry<String, Bundle> entry : this.eventsFilter.entrySet()) {
                DroneApi.this.dispatchAttributeEvent(entry.getKey(), entry.getValue());
            }
            this.eventsFilter.clear();
            DroneApi.this.handler.removeCallbacks((Runnable)this);
            if (DroneApi.this.isEventsBufferingEnabled()) {
                DroneApi.this.handler.postDelayed((Runnable)this, DroneApi.this.connectionParams.getEventsDispatchingPeriod());
            }
        }
    };
    private final Context context;
    private final Handler handler;
    private final ConcurrentLinkedQueue<IObserver> observersList;
    private final ConcurrentLinkedQueue<IMavlinkObserver> mavlinkObserversList;
    private DroneManager droneMgr;
    private final IApiListener apiListener;
    private final String ownerId;
    private final ClientInfo clientInfo;
    private final DroidPlannerService service;
    private final ConcurrentLinkedQueue<EventInfo> eventsBuffer = new ConcurrentLinkedQueue();
    private ConnectionParameter connectionParams;

    DroneApi(DroidPlannerService dpService, IApiListener listener, String ownerId) {
        this.service = dpService;
        this.context = dpService.getApplicationContext();
        this.handler = new Handler(Looper.getMainLooper());
        this.ownerId = ownerId;
        this.observersList = new ConcurrentLinkedQueue();
        this.mavlinkObserversList = new ConcurrentLinkedQueue();
        this.apiListener = listener;
        int apiVersionCode = -1;
        int clientVersionCode = -1;
        try {
            this.apiListener.asBinder().linkToDeath((IBinder.DeathRecipient)this, 0);
            this.checkForSelfRelease();
            apiVersionCode = this.apiListener.getApiVersionCode();
            clientVersionCode = this.apiListener.getClientVersionCode();
        }
        catch (RemoteException e) {
            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            dpService.releaseDroneApi(this.ownerId);
        }
        this.clientInfo = new ClientInfo(this.ownerId, apiVersionCode, clientVersionCode);
    }

    void destroy() {
        Timber.d((String)"Destroying drone api instance for %s", (Object[])new Object[]{this.ownerId});
        this.observersList.clear();
        this.mavlinkObserversList.clear();
        try {
            this.apiListener.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
        }
        catch (NoSuchElementException e) {
            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
        }
        this.service.disconnectDroneManager(this.droneMgr, this.clientInfo);
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public DroneManager getDroneManager() {
        return this.droneMgr;
    }

    private Drone getDrone() {
        if (this.droneMgr == null) {
            return null;
        }
        return this.droneMgr.getDrone();
    }

    private boolean isEventsBufferingEnabled() {
        return this.connectionParams != null && this.connectionParams.getEventsDispatchingPeriod() > 0L;
    }

    @Override
    public Bundle getAttribute(String type) throws RemoteException {
        Bundle carrier = new Bundle();
        switch (type) {
            case "com.o3dr.services.android.lib.attribute.CAMERA": {
                carrier.putParcelable(type, (Parcelable)CommonApiUtils.getCameraProxy(this.getDrone(), this.service.getCameraDetails()));
                break;
            }
            default: {
                DroneAttribute attribute;
                if (this.droneMgr == null || (attribute = this.droneMgr.getAttribute(this.clientInfo, type)) == null) break;
                if (this.clientInfo.clientVersionCode < 206080 && attribute instanceof Mission) {
                    Mission proxyMission = (Mission)attribute;
                    List<MissionItem> missionItems = proxyMission.getMissionItems();
                    int missionItemsCount = missionItems.size();
                    for (int i = 0; i < missionItemsCount; ++i) {
                        MissionItem missionItem = missionItems.get(i);
                        if (!(missionItem instanceof ResetROI)) continue;
                        missionItems.remove(i);
                        RegionOfInterest replacement = new RegionOfInterest();
                        replacement.setCoordinate(new LatLongAlt(0.0, 0.0, 0.0));
                        missionItems.add(i, replacement);
                    }
                }
                carrier.putParcelable(type, (Parcelable)attribute);
            }
        }
        return carrier;
    }

    public boolean isConnected() {
        return this.droneMgr != null && this.droneMgr.isConnected();
    }

    private ConnectionParameter checkConnectionParameter(ConnectionParameter connParams) throws ConnectionException {
        ConnectionParameter update;
        if (connParams == null) {
            throw new ConnectionException("Invalid connection parameters");
        }
        if (SoloConnection.isUdpSoloConnection(this.context, connParams) && (update = SoloConnection.getSoloConnectionParameterFromUdp(this.context, connParams)) != null) {
            return update;
        }
        return connParams;
    }

    public void connect(ConnectionParameter connParams) {
        try {
            ConnectionParameter currentConnParams;
            connParams = this.checkConnectionParameter(connParams);
            ConnectionParameter connectionParameter = currentConnParams = this.connectionParams == null ? this.connectionParams : this.checkConnectionParameter(this.connectionParams);
            if (!connParams.equals(currentConnParams)) {
                if (this.droneMgr != null) {
                    LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-6, "Connection already started with different connection parameters");
                    this.onConnectionStatus(connectionStatus);
                    return;
                }
                this.connectionParams = connParams;
                this.droneMgr = this.service.connectDroneManager(this.connectionParams, this.ownerId, this);
                if (this.isEventsBufferingEnabled()) {
                    this.eventsBuffer.clear();
                    this.handler.postDelayed(this.eventsDispatcher, this.connectionParams.getEventsDispatchingPeriod());
                }
            }
        }
        catch (ConnectionException e) {
            LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-4, e.getMessage());
            this.onConnectionStatus(connectionStatus);
            this.disconnect();
        }
    }

    public void disconnect() {
        this.service.disconnectDroneManager(this.droneMgr, this.clientInfo);
        this.connectionParams = null;
        this.droneMgr = null;
        this.handler.removeCallbacks(this.eventsDispatcher);
    }

    private void checkForSelfRelease() {
        if (!this.apiListener.asBinder().pingBinder()) {
            Timber.w((String)"Client is not longer available.", (Object[])new Object[0]);
            this.context.startService(new Intent(this.context, DroidPlannerService.class).setAction("org.droidplanner.services.android.action.RELEASE_API_INSTANCE").putExtra("extra_api_instance_app_id", this.ownerId));
        }
    }

    @Override
    public void addAttributesObserver(IObserver observer) throws RemoteException {
        if (observer != null) {
            Timber.d((String)"Adding attributes observer.", (Object[])new Object[0]);
            this.observersList.add(observer);
        }
    }

    @Override
    public void removeAttributesObserver(IObserver observer) throws RemoteException {
        if (observer != null) {
            Timber.d((String)"Removing attributes observer.", (Object[])new Object[0]);
            this.observersList.remove(observer);
            this.checkForSelfRelease();
        }
    }

    @Override
    public void addMavlinkObserver(IMavlinkObserver observer) throws RemoteException {
        if (observer != null) {
            this.mavlinkObserversList.add(observer);
        }
    }

    @Override
    public void removeMavlinkObserver(IMavlinkObserver observer) throws RemoteException {
        if (observer != null) {
            this.mavlinkObserversList.remove(observer);
            this.checkForSelfRelease();
        }
    }

    @Override
    public void executeAction(Action action, ICommandListener listener) throws RemoteException {
        if (action == null) {
            return;
        }
        String type = action.getType();
        if (type == null) {
            return;
        }
        Bundle data = action.getData();
        if (data != null) {
            data.setClassLoader(this.context.getClassLoader());
        }
        Drone drone = this.getDrone();
        switch (type) {
            case "com.o3dr.services.android.action.CONNECT": {
                ConnectionParameter parameter = (ConnectionParameter)data.getParcelable("extra_connect_parameter");
                this.connect(parameter);
                break;
            }
            case "com.o3dr.services.android.action.DISCONNECT": {
                this.disconnect();
                break;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.camera.START_VIDEO_STREAM": {
                Surface videoSurface = (Surface)data.getParcelable("extra_video_display");
                String videoTag = data.getString("extra_video_tag", "");
                Bundle videoProps = data.getBundle("extra_video_properties");
                if (videoProps == null) {
                    videoProps = new Bundle();
                    videoProps.putInt("extra_video_props_udp_port", 5600);
                }
                CommonApiUtils.startVideoStream(drone, videoProps, this.ownerId, videoTag, videoSurface, listener);
                break;
            }
            case "com.o3dr.services.android.action.camera.START_VIDEO_STREAM_FOR_OBSERVER": {
                String videoTag = data.getString("extra_video_tag", "");
                CommonApiUtils.startVideoStreamForObserver(drone, this.ownerId, videoTag, listener);
                break;
            }
            case "com.o3dr.services.android.lib.drone.companion.solo.action.camera.STOP_VIDEO_STREAM": {
                String videoTag = data.getString("extra_video_tag", "");
                CommonApiUtils.stopVideoStream(drone, this.ownerId, videoTag, listener);
                break;
            }
            case "com.o3dr.services.android.action.camera.STOP_VIDEO_STREAM_FOR_OBSERVER": {
                String videoTag = data.getString("extra_video_tag", "");
                CommonApiUtils.stopVideoStreamForObserver(drone, this.ownerId, videoTag, listener);
                break;
            }
            case "com.o3dr.services.android.action.BUILD_COMPLEX_MISSION_ITEM": {
                if (drone instanceof MavLinkDrone || drone == null) {
                    CommonApiUtils.buildComplexMissionItem((MavLinkDrone)drone, data);
                    break;
                }
                CommonApiUtils.postErrorEvent(3, listener);
                break;
            }
            case "com.o3dr.services.android.action.SAVE_MISSION": {
                Mission mission = (Mission)data.getParcelable("extra_mission");
                Uri saveUri = (Uri)data.getParcelable("extra_save_mission_uri");
                if (saveUri == null) {
                    CommonApiUtils.postErrorEvent(4, listener);
                    break;
                }
                MissionUtils.saveMission(this.context, mission, saveUri, listener);
                break;
            }
            case "com.o3dr.services.android.action.LOAD_MISSION": {
                Mission mission;
                Uri loadUri = (Uri)data.getParcelable("extra_load_mission_uri");
                boolean setMission = data.getBoolean("extra_set_loaded_mission", false);
                if (loadUri == null || (mission = MissionUtils.loadMission(this.context, loadUri)) == null) break;
                data.putParcelable("extra_mission", (Parcelable)mission);
                if (!setMission) break;
                Bundle params = new Bundle();
                params.putParcelable("extra_mission", (Parcelable)mission);
                params.putBoolean("extra_push_to_drone", false);
                this.executeAction(new Action("com.o3dr.services.android.action.SET_MISSION", params), listener);
                break;
            }
            default: {
                if (this.droneMgr != null) {
                    this.droneMgr.executeAsyncAction(this.clientInfo, action, listener);
                    break;
                }
                CommonApiUtils.postErrorEvent(4, listener);
            }
        }
    }

    @Override
    public void executeAsyncAction(Action action, ICommandListener listener) throws RemoteException {
        this.executeAction(action, listener);
    }

    @Override
    public void performAction(Action action) throws RemoteException {
        this.executeAction(action, null);
    }

    @Override
    public void performAsyncAction(Action action) throws RemoteException {
        this.performAction(action);
    }

    private void notifyAttributeUpdate(List<Pair<String, Bundle>> attributesInfo) {
        if (this.observersList.isEmpty() || attributesInfo == null || attributesInfo.isEmpty()) {
            return;
        }
        for (Pair<String, Bundle> info : attributesInfo) {
            this.notifyAttributeUpdate((String)info.first, (Bundle)info.second);
        }
    }

    private void notifyAttributeUpdate(String attributeEvent, Bundle extrasBundle) {
        if (this.observersList.isEmpty() || attributeEvent == null) {
            return;
        }
        if ("com.o3dr.services.android.lib.attribute.event.STATE_CONNECTED".equals(attributeEvent) || "com.o3dr.services.android.lib.attribute.event.STATE_DISCONNECTED".equals(attributeEvent) || !this.isEventsBufferingEnabled()) {
            this.dispatchAttributeEvent(attributeEvent, extrasBundle);
        } else {
            this.eventsBuffer.add(EventInfo.obtain(attributeEvent, extrasBundle));
        }
    }

    private void dispatchAttributeEvent(String attributeEvent, Bundle extrasBundle) {
        for (IObserver observer : this.observersList) {
            try {
                observer.onAttributeUpdated(attributeEvent, extrasBundle);
            }
            catch (RemoteException e) {
                Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                try {
                    this.removeAttributesObserver(observer);
                }
                catch (RemoteException e1) {
                    Timber.e((Throwable)e, (String)e1.getMessage(), (Object[])new Object[0]);
                }
            }
        }
    }

    public void onReceivedMavLinkMessage(MAVLinkMessage msg) {
        if (this.mavlinkObserversList.isEmpty()) {
            return;
        }
        if (msg != null) {
            MavlinkMessageWrapper msgWrapper = new MavlinkMessageWrapper(msg);
            for (IMavlinkObserver observer : this.mavlinkObserversList) {
                try {
                    observer.onMavlinkMessageReceived(msgWrapper);
                }
                catch (RemoteException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    try {
                        this.removeMavlinkObserver(observer);
                    }
                    catch (RemoteException e1) {
                        Timber.e((Throwable)e1, (String)e1.getMessage(), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    public void onMessageLogged(int logLevel, String message) {
        Bundle args = new Bundle(2);
        args.putInt("com.o3dr.services.android.lib.attribute.event.extra.AUTOPILOT_MESSAGE_LEVEL", logLevel);
        args.putString("com.o3dr.services.android.lib.attribute.event.extra.AUTOPILOT_MESSAGE", message);
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.attribute.event.AUTOPILOT_MESSAGE", args);
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public void onAttributeEvent(String attributeEvent, Bundle eventInfo) {
        if (TextUtils.isEmpty((CharSequence)attributeEvent)) {
            return;
        }
        this.notifyAttributeUpdate(attributeEvent, eventInfo);
    }

    public void onDroneEvent(DroneInterfaces.DroneEventsType event, Drone drone) {
        Bundle extrasBundle = new Bundle();
        String droneId = "";
        if (drone != null) {
            droneId = drone.getId();
        }
        extrasBundle.putString("com.o3dr.services.android.lib.attribute.event.extra.VEHICLE_ID", droneId);
        String droneEvent = null;
        ArrayList<Pair<String, Bundle>> attributesInfo = new ArrayList<Pair<String, Bundle>>();
        switch (event) {
            case DISCONNECTED: {
                this.context.sendBroadcast(new Intent("com.o3dr.services.android.lib.gcs.event.action.VEHICLE_DISCONNECTION").putExtra("com.o3dr.services.android.lib.gcs.event.extra.APP_ID", this.ownerId));
                droneEvent = "com.o3dr.services.android.lib.attribute.event.STATE_DISCONNECTED";
                this.eventsBuffer.clear();
                break;
            }
            case GUIDEDPOINT: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.GUIDED_POINT_UPDATED";
                break;
            }
            case RADIO: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.SIGNAL_UPDATED";
                break;
            }
            case RC_IN: {
                break;
            }
            case RC_OUT: {
                break;
            }
            case ARMING_STARTED: 
            case ARMING: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.STATE_ARMING";
                break;
            }
            case AUTOPILOT_WARNING: {
                State droneState = (State)drone.getAttribute("com.o3dr.services.android.lib.attribute.STATE");
                if (droneState != null) {
                    extrasBundle.putString("com.o3dr.services.android.lib.attribute.event.extra.AUTOPILOT_ERROR_ID", droneState.getAutopilotErrorId());
                }
                droneEvent = "com.o3dr.services.android.lib.attribute.event.AUTOPILOT_ERROR";
                break;
            }
            case MODE: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.STATE_VEHICLE_MODE";
                break;
            }
            case ATTITUDE: 
            case ORIENTATION: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.ATTITUDE_UPDATED";
                break;
            }
            case SPEED: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.SPEED_UPDATED";
                break;
            }
            case BATTERY: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.BATTERY_UPDATED";
                break;
            }
            case STATE: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.STATE_UPDATED";
                break;
            }
            case MISSION_UPDATE: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.MISSION_UPDATED";
                break;
            }
            case MISSION_RECEIVED: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.MISSION_RECEIVED";
                break;
            }
            case FIRMWARE: 
            case TYPE: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.TYPE_UPDATED";
                break;
            }
            case HOME: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.HOME_UPDATED";
                break;
            }
            case CALIBRATION_IMU: {
                if (!(drone instanceof MavLinkDrone)) break;
                String calIMUMessage = ((MavLinkDrone)drone).getCalibrationSetup().getMessage();
                extrasBundle.putString("com.o3dr.services.android.lib.attribute.event.extra.CALIBRATION_IMU_MESSAGE", calIMUMessage);
                droneEvent = "com.o3dr.services.android.lib.attribute.event.CALIBRATION_IMU";
                break;
            }
            case CALIBRATION_TIMEOUT: {
                if (!(drone instanceof MavLinkDrone)) break;
                AccelCalibration accelCalibration = ((MavLinkDrone)drone).getCalibrationSetup();
                String message = accelCalibration.getMessage();
                if (accelCalibration.isCalibrating() && TextUtils.isEmpty((CharSequence)message)) {
                    accelCalibration.cancelCalibration();
                    droneEvent = "com.o3dr.services.android.lib.attribute.event.HEARTBEAT_TIMEOUT";
                    break;
                }
                extrasBundle.putString("com.o3dr.services.android.lib.attribute.event.extra.CALIBRATION_IMU_MESSAGE", message);
                droneEvent = "com.o3dr.services.android.lib.attribute.event.CALIBRATION_IMU_TIMEOUT";
                break;
            }
            case HEARTBEAT_TIMEOUT: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.HEARTBEAT_TIMEOUT";
                break;
            }
            case CONNECTING: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.STATE_CONNECTING";
                break;
            }
            case HEARTBEAT_FIRST: {
                Bundle heartBeatExtras = new Bundle();
                heartBeatExtras.putString("com.o3dr.services.android.lib.attribute.event.extra.VEHICLE_ID", drone.getId());
                if (drone instanceof MavLinkDrone) {
                    heartBeatExtras.putInt("com.o3dr.services.android.lib.attribute.event.extra.MAVLINK_VERSION", ((MavLinkDrone)drone).getMavlinkVersion());
                }
                attributesInfo.add((Pair<String, Bundle>)Pair.create((Object)"com.o3dr.services.android.lib.attribute.event.HEARTBEAT_FIRST", (Object)heartBeatExtras));
            }
            case CONNECTED: {
                ConnectionParameter sanitizedParameter = this.connectionParams.clone();
                this.context.sendBroadcast(new Intent("com.o3dr.services.android.lib.gcs.event.action.VEHICLE_CONNECTION").putExtra("com.o3dr.services.android.lib.gcs.event.extra.APP_ID", this.ownerId).putExtra("com.o3dr.services.android.lib.gcs.event.extra.VEHICLE_CONNECTION_PARAMETER", (Parcelable)sanitizedParameter));
                attributesInfo.add((Pair<String, Bundle>)Pair.create((Object)"com.o3dr.services.android.lib.attribute.event.STATE_CONNECTED", (Object)extrasBundle));
                break;
            }
            case HEARTBEAT_RESTORED: {
                if (drone instanceof MavLinkDrone) {
                    extrasBundle.putInt("com.o3dr.services.android.lib.attribute.event.extra.MAVLINK_VERSION", ((MavLinkDrone)drone).getMavlinkVersion());
                }
                droneEvent = "com.o3dr.services.android.lib.attribute.event.HEARTBEAT_RESTORED";
                break;
            }
            case MISSION_SENT: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.MISSION_SENT";
                break;
            }
            case INVALID_POLYGON: {
                break;
            }
            case MISSION_WP_UPDATE: {
                if (!(drone instanceof MavLinkDrone)) break;
                int currentWaypoint = ((MavLinkDrone)drone).getMissionStats().getCurrentWP();
                extrasBundle.putInt("com.o3dr.services.android.lib.attribute.event.extra.MISSION_CURRENT_WAYPOINT", currentWaypoint);
                droneEvent = "com.o3dr.services.android.lib.attribute.event.MISSION_ITEM_UPDATED";
                break;
            }
            case MISSION_WP_REACHED: {
                if (!(drone instanceof MavLinkDrone)) break;
                int lastReachedWaypoint = ((MavLinkDrone)drone).getMissionStats().getLastReachedWP();
                extrasBundle.putInt("com.o3dr.services.android.lib.attribute.event.extra.MISSION_REACHED_WAYPOINT", lastReachedWaypoint);
                droneEvent = "com.o3dr.services.android.lib.attribute.event.MISSION_ITEM_REACHED";
                break;
            }
            case ALTITUDE: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.ALTITUDE_UPDATED";
                break;
            }
            case WARNING_SIGNAL_WEAK: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.SIGNAL_WEAK";
                break;
            }
            case WARNING_NO_GPS: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.WARNING_NO_GPS";
                break;
            }
            case MAGNETOMETER: {
                break;
            }
            case FOOTPRINT: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.CAMERA_FOOTPRINTS_UPDATED";
                break;
            }
            case EKF_STATUS_UPDATE: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.STATE_EKF_REPORT";
                break;
            }
            case EKF_POSITION_STATE_UPDATE: {
                droneEvent = "com.o3dr.services.android.lib.attribute.event.STATE_EKF_POSITION";
            }
        }
        if (droneEvent != null) {
            this.notifyAttributeUpdate(droneEvent, extrasBundle);
        }
        if (!attributesInfo.isEmpty()) {
            this.notifyAttributeUpdate(attributesInfo);
        }
    }

    @Override
    public void onBeginReceivingParameters() {
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.attribute.event.PARAMETERS_REFRESH_STARTED", null);
    }

    @Override
    public void onParameterReceived(Parameter parameter, int index, int count) {
        Bundle paramsBundle = new Bundle(4);
        paramsBundle.putInt("com.o3dr.services.android.lib.attribute.event.extra.PARAMETER_INDEX", index);
        paramsBundle.putInt("com.o3dr.services.android.lib.attribute.event.extra.PARAMETERS_COUNT", count);
        paramsBundle.putString("com.o3dr.services.android.lib.attribute.event.extra.PARAMETER_NAME", parameter.getName());
        paramsBundle.putDouble("com.o3dr.services.android.lib.attribute.event.extra.PARAMETER_VALUE", parameter.getValue());
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.attribute.event.PARAMETERS_RECEIVED", paramsBundle);
    }

    @Override
    public void onEndReceivingParameters() {
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.attribute.event.PARAMETERS_REFRESH_ENDED", null);
    }

    public void onConnectionStatus(LinkConnectionStatus connectionStatus) {
        switch (connectionStatus.getStatusCode()) {
            case "FAILED": {
                this.disconnect();
                this.checkForSelfRelease();
                break;
            }
            case "DISCONNECTED": {
                this.disconnect();
                this.checkForSelfRelease();
            }
        }
        Bundle extras = new Bundle();
        extras.putParcelable("com.o3dr.services.android.lib.gcs.link.event.extra.CONNECTION_STATUS", (Parcelable)connectionStatus);
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.gcs.link.event.LINK_STATE_UPDATED", extras);
    }

    public void binderDied() {
        this.checkForSelfRelease();
    }

    @Override
    public void onCalibrationCancelled() {
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.attribute.event.CALIBRATION_MAG_CANCELLED", null);
    }

    @Override
    public void onCalibrationProgress(msg_mag_cal_progress progress) {
        Bundle progressBundle = new Bundle(1);
        progressBundle.putParcelable("com.o3dr.services.android.lib.attribute.event.extra.CALIBRATION_MAG_PROGRESS", (Parcelable)CommonApiUtils.getMagnetometerCalibrationProgress(progress));
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.attribute.event.CALIBRATION_MAG_PROGRESS", progressBundle);
    }

    @Override
    public void onCalibrationCompleted(msg_mag_cal_report report) {
        Bundle reportBundle = new Bundle(1);
        reportBundle.putParcelable("com.o3dr.services.android.lib.attribute.event.extra.CALIBRATION_MAG_RESULT", (Parcelable)CommonApiUtils.getMagnetometerCalibrationResult(report));
        this.notifyAttributeUpdate("com.o3dr.services.android.lib.attribute.event.CALIBRATION_MAG_COMPLETED", reportBundle);
    }

    private static class EventInfo {
        private static final ConcurrentLinkedQueue<EventInfo> sPool = new ConcurrentLinkedQueue();
        String event;
        Bundle extras;

        private EventInfo() {
        }

        static EventInfo obtain(String event, Bundle extras) {
            EventInfo eventInfo = sPool.poll();
            if (eventInfo == null) {
                eventInfo = new EventInfo();
            }
            eventInfo.event = event;
            eventInfo.extras = extras;
            return eventInfo;
        }

        static void recycle(EventInfo eventInfo) {
            if (eventInfo != null) {
                eventInfo.event = null;
                eventInfo.extras = null;
                sPool.offer(eventInfo);
            }
        }
    }

    public static class ClientInfo {
        public final String appId;
        public final int apiVersionCode;
        public final int clientVersionCode;

        public ClientInfo(String appId, int apiVersionCode, int clientVersionCode) {
            this.apiVersionCode = apiVersionCode;
            this.appId = appId;
            this.clientVersionCode = clientVersionCode;
        }
    }
}

