/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.util.googleApi;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class GoogleApiClientManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final String TAG = GoogleApiClientManager.class.getSimpleName();
    private final Runnable mDriverRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                while (GoogleApiClientManager.this.isStarted.get()) {
                    if (!GoogleApiClientManager.this.mGoogleApiClient.isConnected()) {
                        GoogleApiClientManager.this.stop();
                        continue;
                    }
                    GoogleApiClientTask task = (GoogleApiClientTask)GoogleApiClientManager.this.mTaskQueue.take();
                    if (task == null) continue;
                    if (task.mRunOnBackgroundThread) {
                        GoogleApiClientManager.this.mBgHandler.post((Runnable)task);
                        continue;
                    }
                    GoogleApiClientManager.this.mMainHandler.post((Runnable)task);
                }
            }
            catch (InterruptedException e) {
                Log.v((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
    };
    private final GoogleApiClientTask stopTask = new GoogleApiClientTask(){

        @Override
        protected void doRun() {
            GoogleApiClientManager.this.stop();
        }
    };
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private Thread mDriverThread;
    private final Handler mMainHandler;
    private Handler mBgHandler;
    private HandlerThread mBgHandlerThread;
    private final Context mContext;
    private final GoogleApiClient mGoogleApiClient;
    private ManagerListener listener;
    private final LinkedBlockingQueue<GoogleApiClientTask> mTaskQueue = new LinkedBlockingQueue();

    public GoogleApiClientManager(Context context, Handler handler, Api<? extends Api.ApiOptions.NotRequiredOptions>[] apis) {
        this.mContext = context;
        this.mMainHandler = handler;
        GoogleApiClient.Builder apiBuilder = new GoogleApiClient.Builder(context);
        for (Api<? extends Api.ApiOptions.NotRequiredOptions> api : apis) {
            apiBuilder.addApi(api);
        }
        this.mGoogleApiClient = apiBuilder.addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
    }

    public void setManagerListener(ManagerListener listener) {
        this.listener = listener;
    }

    private void destroyBgHandler() {
        if (this.mBgHandlerThread != null && this.mBgHandlerThread.isAlive()) {
            this.mBgHandlerThread.quit();
            this.mBgHandlerThread.interrupt();
            this.mBgHandlerThread = null;
        }
        this.mBgHandler = null;
    }

    private void destroyDriverThread() {
        if (this.mDriverThread != null && this.mDriverThread.isAlive()) {
            this.mDriverThread.interrupt();
            this.mDriverThread = null;
        }
    }

    private void initializeBgHandler() {
        if (this.mBgHandlerThread == null || this.mBgHandlerThread.isInterrupted()) {
            this.mBgHandlerThread = new HandlerThread("GAC Manager Background Thread");
            this.mBgHandlerThread.start();
            this.mBgHandler = null;
        }
        if (this.mBgHandler == null) {
            this.mBgHandler = new Handler(this.mBgHandlerThread.getLooper());
        }
    }

    private void initializeDriverThread() {
        if (this.mDriverThread == null || this.mDriverThread.isInterrupted()) {
            this.mDriverThread = new Thread(this.mDriverRunnable, "GAC Manager Driver Thread");
            this.mDriverThread.start();
        }
    }

    public boolean addTask(GoogleApiClientTask task) {
        if (!this.isStarted()) {
            Log.d((String)TAG, (String)"GoogleApiClientManager is not started.");
            return false;
        }
        task.gApiClient = this.mGoogleApiClient;
        task.taskQueue = this.mTaskQueue;
        task.mRunOnBackgroundThread = false;
        return this.mTaskQueue.offer(task);
    }

    public boolean addTaskToBackground(GoogleApiClientTask task) {
        if (!this.isStarted()) {
            Log.d((String)TAG, (String)"GoogleApiClientManager is not started.");
            return false;
        }
        task.gApiClient = this.mGoogleApiClient;
        task.taskQueue = this.mTaskQueue;
        task.mRunOnBackgroundThread = true;
        return this.mTaskQueue.offer(task);
    }

    private boolean isStarted() {
        return this.isStarted.get();
    }

    public void start() {
        boolean isValid;
        int playStatus = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.mContext);
        boolean bl = isValid = playStatus == 0;
        if (isValid) {
            this.mTaskQueue.clear();
            this.isStarted.set(true);
            if (this.mGoogleApiClient.isConnected()) {
                this.onConnected(null);
            } else if (!this.mGoogleApiClient.isConnecting()) {
                this.mGoogleApiClient.connect();
            }
        } else {
            Log.e((String)TAG, (String)"Google Play Services is unavailable.");
            if (this.listener != null) {
                this.listener.onUnavailableGooglePlayServices(playStatus);
            }
        }
    }

    private void stop() {
        this.isStarted.set(false);
        this.destroyDriverThread();
        this.destroyBgHandler();
        this.mTaskQueue.clear();
        if (this.mGoogleApiClient.isConnected() || this.mGoogleApiClient.isConnecting()) {
            this.mGoogleApiClient.disconnect();
        }
        if (this.listener != null) {
            this.listener.onManagerStopped();
        }
    }

    public void stopSafely() {
        this.addTask(this.stopTask);
    }

    public void onConnected(Bundle bundle) {
        this.initializeBgHandler();
        this.initializeDriverThread();
        if (this.listener != null) {
            this.listener.onManagerStarted();
        }
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (this.listener != null) {
            this.listener.onGoogleApiConnectionError(connectionResult);
        }
        this.stop();
    }

    public static abstract class GoogleApiClientTask
    implements Runnable {
        private boolean mRunOnBackgroundThread = false;
        private GoogleApiClient gApiClient;
        private LinkedBlockingQueue<GoogleApiClientTask> taskQueue;

        protected GoogleApiClient getGoogleApiClient() {
            return this.gApiClient;
        }

        @Override
        public void run() {
            if (!this.gApiClient.isConnected()) {
                this.taskQueue.offer(this);
                return;
            }
            this.doRun();
        }

        protected abstract void doRun();
    }

    public static interface ManagerListener {
        public void onGoogleApiConnectionError(ConnectionResult var1);

        public void onUnavailableGooglePlayServices(int var1);

        public void onManagerStarted();

        public void onManagerStopped();
    }
}

