/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv.mpcc;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import java.nio.ByteBuffer;

public class SoloSplinePoint
extends TLVPacket {
    public static final int MESSAGE_LENGTH = 44;
    public static final short STATUS_SUCCESS = 0;
    public static final short STATUS_MODE_ERROR = -1;
    public static final short STATUS_KEYPOINTS_TOO_CLOSE_ERROR = -2;
    public static final short STATUS_DUPLICATE_INDEX_ERROR = -3;
    private short version;
    private float absAltReference;
    private int index;
    private LatLongAlt coordinate;
    private float pitch;
    private float yaw;
    private float uPosition;
    private short status;
    public static final Parcelable.Creator<SoloSplinePoint> CREATOR = new Parcelable.Creator<SoloSplinePoint>(){

        public SoloSplinePoint createFromParcel(Parcel source) {
            return new SoloSplinePoint(source);
        }

        public SoloSplinePoint[] newArray(int size) {
            return new SoloSplinePoint[size];
        }
    };

    public SoloSplinePoint(short version, float absAltReference, int index, LatLongAlt coordinate, float pitch, float yaw, float uPosition, short status) {
        super(52, 44);
        this.version = version;
        this.absAltReference = absAltReference;
        this.coordinate = coordinate;
        this.index = index;
        this.pitch = pitch;
        this.status = status;
        this.uPosition = uPosition;
        this.yaw = yaw;
    }

    public SoloSplinePoint(ByteBuffer dataBuffer) {
        this(dataBuffer.getShort(), dataBuffer.getFloat(), dataBuffer.getInt(), new LatLongAlt(dataBuffer.getDouble(), dataBuffer.getDouble(), dataBuffer.getFloat()), dataBuffer.getFloat(), dataBuffer.getFloat(), dataBuffer.getFloat(), dataBuffer.getShort());
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putShort(this.version);
        valueCarrier.putFloat(this.absAltReference);
        valueCarrier.putInt(this.index);
        valueCarrier.putDouble(this.coordinate.getLatitude());
        valueCarrier.putDouble(this.coordinate.getLongitude());
        valueCarrier.putFloat((float)this.coordinate.getAltitude());
        valueCarrier.putFloat(this.pitch);
        valueCarrier.putFloat(this.yaw);
        valueCarrier.putFloat(this.uPosition);
        valueCarrier.putShort(this.status);
    }

    public short getVersion() {
        return this.version;
    }

    public float getAbsAltReference() {
        return this.absAltReference;
    }

    public LatLongAlt getCoordinate() {
        return this.coordinate;
    }

    public int getIndex() {
        return this.index;
    }

    public float getPitch() {
        return this.pitch;
    }

    public short getStatus() {
        return this.status;
    }

    public float getUPosition() {
        return this.uPosition;
    }

    public float getYaw() {
        return this.yaw;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt((int)this.version);
        dest.writeFloat(this.absAltReference);
        dest.writeInt(this.index);
        dest.writeParcelable((Parcelable)this.coordinate, 0);
        dest.writeFloat(this.pitch);
        dest.writeFloat(this.yaw);
        dest.writeFloat(this.uPosition);
        dest.writeInt((int)this.status);
    }

    protected SoloSplinePoint(Parcel in) {
        super(in);
        this.version = (short)in.readInt();
        this.absAltReference = in.readFloat();
        this.index = in.readInt();
        this.coordinate = (LatLongAlt)in.readParcelable(LatLongAlt.class.getClassLoader());
        this.pitch = in.readFloat();
        this.yaw = in.readFloat();
        this.uPosition = in.readFloat();
        this.status = (short)in.readInt();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SoloSplinePoint that = (SoloSplinePoint)o;
        if (this.version != that.version) {
            return false;
        }
        if (Float.compare(that.absAltReference, this.absAltReference) != 0) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (Float.compare(that.pitch, this.pitch) != 0) {
            return false;
        }
        if (Float.compare(that.yaw, this.yaw) != 0) {
            return false;
        }
        if (Float.compare(that.uPosition, this.uPosition) != 0) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        return this.coordinate.equals(that.coordinate);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + (this.absAltReference != 0.0f ? Float.floatToIntBits(this.absAltReference) : 0);
        result = 31 * result + this.index;
        result = 31 * result + this.coordinate.hashCode();
        result = 31 * result + (this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0);
        result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
        result = 31 * result + (this.uPosition != 0.0f ? Float.floatToIntBits(this.uPosition) : 0);
        result = 31 * result + this.status;
        return result;
    }

    @Override
    public String toString() {
        return "SoloSplinePoint{version=" + this.version + ", absAltReference=" + this.absAltReference + ", index=" + this.index + ", coordinate=" + this.coordinate + ", pitch=" + this.pitch + ", yaw=" + this.yaw + ", uPosition=" + this.uPosition + ", status=" + this.status + '}';
    }
}

