/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.coordinate;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public class LatLong
implements Parcelable,
Serializable {
    private static final long serialVersionUID = -5809863197722412339L;
    private double latitude;
    private double longitude;
    public static final Parcelable.Creator<LatLong> CREATOR = new Parcelable.Creator<LatLong>(){

        public LatLong createFromParcel(Parcel source) {
            return (LatLong)source.readSerializable();
        }

        public LatLong[] newArray(int size) {
            return new LatLong[size];
        }
    };

    public LatLong(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public LatLong(LatLong copy) {
        this(copy.getLatitude(), copy.getLongitude());
    }

    public void set(LatLong update) {
        this.latitude = update.latitude;
        this.longitude = update.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public LatLong dot(double scalar) {
        return new LatLong(this.latitude * scalar, this.longitude * scalar);
    }

    public LatLong negate() {
        return new LatLong(this.latitude * -1.0, this.longitude * -1.0);
    }

    public LatLong subtract(LatLong coord) {
        return new LatLong(this.latitude - coord.latitude, this.longitude - coord.longitude);
    }

    public LatLong sum(LatLong coord) {
        return new LatLong(this.latitude + coord.latitude, this.longitude + coord.longitude);
    }

    public static LatLong sum(LatLong ... toBeAdded) {
        double latitude = 0.0;
        double longitude = 0.0;
        for (LatLong coord : toBeAdded) {
            latitude += coord.latitude;
            longitude += coord.longitude;
        }
        return new LatLong(latitude, longitude);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLong)) {
            return false;
        }
        LatLong latLong = (LatLong)o;
        if (Double.compare(latLong.latitude, this.latitude) != 0) {
            return false;
        }
        return Double.compare(latLong.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "LatLong{latitude=" + this.latitude + ", longitude=" + this.longitude + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this);
    }
}

