/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.video;

import android.annotation.TargetApi;
import android.util.Log;
import com.o3dr.android.client.utils.video.NaluChunk;
import java.nio.ByteBuffer;
import java.util.Locale;

@TargetApi(value=18)
class NaluChunkAssembler {
    private static final String TAG = NaluChunkAssembler.class.getSimpleName();
    private final NaluChunk assembledNaluChunk = new NaluChunk(1, 0x100000, NaluChunk.START_CODE);
    private final NaluChunk paramsNaluChunk = new NaluChunk(2, 256, NaluChunk.START_CODE);
    private final NaluChunk eosNaluChunk;
    private static final int SPS_BUFFER_INDEX = 0;
    private boolean isSpsSet = false;
    private static final int PPS_BUFFER_INDEX = 1;
    private boolean isPpsSet = false;
    private int prevSeq = -1;
    private int naluCounter = 0;
    private static final long DELTA_PRESENTATION_TIME = 42000L;

    NaluChunkAssembler() {
        this.paramsNaluChunk.type = 78;
        this.paramsNaluChunk.flags = 2;
        this.eosNaluChunk = new NaluChunk(1, 0, null);
        this.eosNaluChunk.flags = 4;
    }

    void reset() {
        this.isSpsSet = false;
        this.isPpsSet = false;
        this.assembledNaluChunk.payloads[0].reset();
        this.paramsNaluChunk.payloads[0].reset();
        this.paramsNaluChunk.payloads[1].reset();
    }

    private boolean areParametersSet() {
        return this.isSpsSet && this.isPpsSet;
    }

    NaluChunk getEndOfStream() {
        return this.eosNaluChunk;
    }

    NaluChunk getParametersSet() {
        if (this.areParametersSet()) {
            return this.paramsNaluChunk;
        }
        return null;
    }

    NaluChunk assembleNALUChunk(byte[] buffer, int bufferLength) {
        int payloadOffset;
        int expectedSeq;
        byte nalHeaderByte = buffer[12];
        int forbiddenBit = (nalHeaderByte & 0x80) >> 7;
        if (forbiddenBit != 0) {
            Log.w((String)TAG, (String)"Forbidden bit is set, indicating possible errors.");
            return null;
        }
        long rtpTimestamp = 0L;
        rtpTimestamp |= ((long)buffer[4] & 0xFFL) << 24;
        rtpTimestamp |= ((long)buffer[5] & 0xFFL) << 16;
        rtpTimestamp |= ((long)buffer[6] & 0xFFL) << 8;
        rtpTimestamp |= (long)buffer[7] & 0xFFL;
        int sequenceNumber = (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        int nalType = nalHeaderByte & 0x1F;
        if (nalType <= 0) {
            Log.d((String)TAG, (String)("Undefined nal type: " + nalType));
            return null;
        }
        if (this.prevSeq != -1 && sequenceNumber != (expectedSeq = this.prevSeq + 1)) {
            Log.v((String)TAG, (String)String.format(Locale.US, "Sequence number is out of order: %d != %d", expectedSeq, sequenceNumber));
        }
        this.prevSeq = sequenceNumber;
        if (nalType <= 23) {
            payloadOffset = 12;
            int payloadLength = bufferLength - 12;
            switch (nalType) {
                case 7: 
                case 8: {
                    ByteBuffer naluData;
                    if (nalType == 7) {
                        naluData = this.paramsNaluChunk.payloads[0];
                        this.isSpsSet = true;
                    } else {
                        naluData = this.paramsNaluChunk.payloads[1];
                        this.isPpsSet = true;
                    }
                    naluData.reset();
                    naluData.put(buffer, 12, payloadLength);
                    if (this.areParametersSet()) {
                        this.paramsNaluChunk.sequenceNumber = sequenceNumber;
                        this.paramsNaluChunk.presentationTime = 0L;
                        return this.paramsNaluChunk;
                    }
                    return null;
                }
            }
            if (!this.areParametersSet()) {
                return null;
            }
            ByteBuffer assembledNaluBuffer = this.assembledNaluChunk.payloads[0];
            assembledNaluBuffer.reset();
            assembledNaluBuffer.put(buffer, 12, payloadLength);
            this.assembledNaluChunk.type = nalType;
            this.assembledNaluChunk.sequenceNumber = sequenceNumber;
            this.assembledNaluChunk.flags = 0;
            this.assembledNaluChunk.presentationTime = (long)this.naluCounter++ * 42000L;
            return this.assembledNaluChunk;
        }
        if (nalType == 28) {
            if (!this.areParametersSet()) {
                return null;
            }
            payloadOffset = 14;
            int payloadLength = bufferLength - 14;
            byte fuIndicatorByte = nalHeaderByte;
            byte fuHeaderByte = buffer[13];
            int fuNalType = fuHeaderByte & 0x1F;
            int startBit = (fuHeaderByte & 0x80) >> 7;
            int endBit = (fuHeaderByte & 0x40) >> 6;
            if (startBit == 1) {
                ByteBuffer assembledNaluBuffer = this.assembledNaluChunk.payloads[0];
                assembledNaluBuffer.reset();
                assembledNaluBuffer.put((byte)(fuIndicatorByte & 0xE0 | fuNalType));
                assembledNaluBuffer.put(buffer, 14, payloadLength);
                boolean isConfig = fuNalType == 7 || fuNalType == 8;
                this.assembledNaluChunk.sequenceNumber = sequenceNumber;
                this.assembledNaluChunk.type = fuNalType;
                this.assembledNaluChunk.flags = isConfig ? 2 : 0;
                return null;
            }
            if (sequenceNumber - 1 != this.assembledNaluChunk.sequenceNumber) {
                return null;
            }
            ByteBuffer assembledNaluBuffer = this.assembledNaluChunk.payloads[0];
            assembledNaluBuffer.put(buffer, 14, payloadLength);
            this.assembledNaluChunk.sequenceNumber = sequenceNumber;
            if (endBit == 1) {
                this.assembledNaluChunk.presentationTime = (long)this.naluCounter++ * 42000L;
                return this.assembledNaluChunk;
            }
            return null;
        }
        return null;
    }
}

