/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;

public class Type
implements DroneAttribute {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_PLANE = 1;
    public static final int TYPE_COPTER = 2;
    public static final int TYPE_ROVER = 10;
    private int droneType = -1;
    private String firmwareVersion;
    private Firmware firmware;
    public static final Parcelable.Creator<Type> CREATOR = new Parcelable.Creator<Type>(){

        public Type createFromParcel(Parcel source) {
            return new Type(source);
        }

        public Type[] newArray(int size) {
            return new Type[size];
        }
    };

    public Type() {
    }

    public Type(int droneType, String firmwareVersion) {
        this.droneType = droneType;
        this.firmwareVersion = firmwareVersion;
        switch (droneType) {
            case 2: {
                this.firmware = Firmware.ARDU_COPTER;
                break;
            }
            case 1: {
                this.firmware = Firmware.ARDU_PLANE;
                break;
            }
            case 10: {
                this.firmware = Firmware.APM_ROVER;
                break;
            }
            default: {
                this.firmware = null;
            }
        }
    }

    public int getDroneType() {
        return this.droneType;
    }

    public Firmware getFirmware() {
        return this.firmware;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setDroneType(int droneType) {
        this.droneType = droneType;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void setFirmware(Firmware firmware) {
        this.firmware = firmware;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.droneType);
        dest.writeString(this.firmwareVersion);
        dest.writeInt(this.firmware == null ? -1 : this.firmware.ordinal());
    }

    private Type(Parcel in) {
        this.droneType = in.readInt();
        this.firmwareVersion = in.readString();
        int tmpFirmware = in.readInt();
        this.firmware = tmpFirmware == -1 ? null : Firmware.values()[tmpFirmware];
    }

    public static enum Firmware {
        ARDU_PLANE("ArduPlane"),
        ARDU_COPTER("ArduCopter"),
        APM_ROVER("APMRover");

        private final String label;

        private Firmware(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

