/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.coordinate;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.coordinate.LatLong;

public class LatLongAlt
extends LatLong {
    private static final long serialVersionUID = -4771550293045623743L;
    private double mAltitude;
    public static final Parcelable.Creator<LatLongAlt> CREATOR = new Parcelable.Creator<LatLongAlt>(){

        public LatLongAlt createFromParcel(Parcel source) {
            return (LatLongAlt)source.readSerializable();
        }

        public LatLongAlt[] newArray(int size) {
            return new LatLongAlt[size];
        }
    };

    public LatLongAlt(double latitude, double longitude, double altitude) {
        super(latitude, longitude);
        this.mAltitude = altitude;
    }

    public LatLongAlt(LatLong location, double altitude) {
        super(location);
        this.mAltitude = altitude;
    }

    public LatLongAlt(LatLongAlt copy) {
        this(copy.getLatitude(), copy.getLongitude(), copy.getAltitude());
    }

    public void set(LatLongAlt source) {
        super.set(source);
        this.mAltitude = source.mAltitude;
    }

    public double getAltitude() {
        return this.mAltitude;
    }

    public void setAltitude(double altitude) {
        this.mAltitude = altitude;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLongAlt)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LatLongAlt that = (LatLongAlt)o;
        return Double.compare(that.mAltitude, this.mAltitude) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.mAltitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return "LatLongAlt{" + superToString + ", mAltitude=" + this.mAltitude + '}';
    }
}

