/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.connection;

import android.os.Handler;
import android.util.Log;
import com.o3dr.android.client.utils.connection.AbstractIpConnection;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class UdpConnection
extends AbstractIpConnection {
    private static final String TAG = UdpConnection.class.getSimpleName();
    private final int serverPort;
    private final int readTimeout;
    private DatagramSocket socket;
    private DatagramPacket sendPacket;
    private DatagramPacket receivePacket;
    private int hostPort;
    private InetAddress hostAddress;

    public UdpConnection(Handler handler, int serverPort, int readBufferSize) {
        this(handler, serverPort, readBufferSize, false, 0);
    }

    public UdpConnection(Handler handler, int serverPort, int readBufferSize, boolean polling, int readTimeout) {
        super(handler, readBufferSize, polling);
        this.serverPort = serverPort;
        this.readTimeout = polling ? (readTimeout > 0 ? readTimeout : 33) : 15000;
    }

    public UdpConnection(Handler handler, String address, int hostPort, int serverPort) throws UnknownHostException {
        super(handler, false, true);
        this.serverPort = serverPort;
        this.hostPort = hostPort;
        this.hostAddress = InetAddress.getByName(address);
        this.readTimeout = 15000;
    }

    @Override
    protected void open() throws IOException {
        Log.d((String)TAG, (String)"Opening udp connection.");
        this.socket = this.serverPort == -1 ? new DatagramSocket() : new DatagramSocket(this.serverPort);
        this.socket.setBroadcast(true);
        this.socket.setReuseAddress(true);
        this.socket.setSoTimeout(this.readTimeout);
    }

    @Override
    protected int read(ByteBuffer buffer) throws IOException {
        if (this.receivePacket == null) {
            this.receivePacket = new DatagramPacket(buffer.array(), buffer.capacity());
        }
        this.socket.receive(this.receivePacket);
        this.hostAddress = this.receivePacket.getAddress();
        this.hostPort = this.receivePacket.getPort();
        return this.receivePacket.getLength();
    }

    @Override
    protected void send(AbstractIpConnection.PacketData data) throws IOException {
        if (this.hostAddress != null) {
            if (this.sendPacket == null) {
                this.sendPacket = new DatagramPacket(data.data, data.dataLength, this.hostAddress, this.hostPort);
            } else {
                this.sendPacket.setData(data.data, 0, data.dataLength);
                this.sendPacket.setAddress(this.hostAddress);
                this.sendPacket.setPort(this.hostPort);
            }
            this.socket.send(this.sendPacket);
        } else {
            Log.w((String)TAG, (String)"Still awaiting connection from remote host.");
        }
    }

    @Override
    protected void close() throws IOException {
        Log.d((String)TAG, (String)"Closing udp connection.");
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

