/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.connection;

import android.os.Handler;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.o3dr.android.client.utils.connection.IpConnectionListener;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIpConnection {
    private static final String TAG = AbstractIpConnection.class.getSimpleName();
    public static final int CONNECTION_TIMEOUT = 15000;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    private static final int DEFAULT_READ_BUFFER_SIZE = 4096;
    private IpConnectionListener ipConnectionListener;
    private final LinkedBlockingQueue<PacketData> packetsToSend = new LinkedBlockingQueue();
    private final AtomicInteger connectionStatus = new AtomicInteger(0);
    private final boolean isSendingDisabled;
    private final boolean isReadingDisabled;
    private final ByteBuffer readBuffer;
    private final Runnable managerTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block19: {
                Process.setThreadPriority((int)-4);
                Thread sendingThread = null;
                try {
                    AbstractIpConnection.this.open();
                    AbstractIpConnection.this.connectionStatus.set(2);
                    if (AbstractIpConnection.this.ipConnectionListener != null) {
                        AbstractIpConnection.this.ipConnectionListener.onIpConnected();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to open ip connection.", (Throwable)e);
                    if (sendingThread != null && sendingThread.isAlive()) {
                        sendingThread.interrupt();
                    }
                    AbstractIpConnection.this.disconnect();
                    Log.i((String)TAG, (String)"Exiting connection manager thread.");
                    return;
                }
                if (!AbstractIpConnection.this.isSendingDisabled) {
                    sendingThread = new Thread(AbstractIpConnection.this.sendingTask, "IP Connection-Sending Thread");
                    sendingThread.start();
                }
                if (AbstractIpConnection.this.isReadingDisabled) {
                    if (sendingThread == null) return;
                    try {
                        sendingThread.join();
                        return;
                    }
                    catch (InterruptedException e) {
                        Log.e((String)TAG, (String)"Error while waiting for sending thread to complete.", (Throwable)e);
                        return;
                    }
                }
                break block19;
                finally {
                    if (sendingThread != null && sendingThread.isAlive()) {
                        sendingThread.interrupt();
                    }
                    AbstractIpConnection.this.disconnect();
                    Log.i((String)TAG, (String)"Exiting connection manager thread.");
                }
            }
            try {
                while (AbstractIpConnection.this.connectionStatus.get() == 2) {
                    AbstractIpConnection.this.readBuffer.clear();
                    try {
                        int packetSize = AbstractIpConnection.this.read(AbstractIpConnection.this.readBuffer);
                        if (packetSize <= 0) continue;
                        AbstractIpConnection.this.readBuffer.limit(packetSize);
                        if (AbstractIpConnection.this.ipConnectionListener == null) continue;
                        AbstractIpConnection.this.readBuffer.rewind();
                        AbstractIpConnection.this.ipConnectionListener.onPacketReceived(AbstractIpConnection.this.readBuffer);
                    }
                    catch (InterruptedIOException e) {
                        if (!AbstractIpConnection.this.isPolling) throw e;
                    }
                }
                return;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error occurred while reading from the connection.", (Throwable)e);
                return;
            }
        }
    };
    private final Runnable sendingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                block7: while (true) {
                    try {
                        while (AbstractIpConnection.this.connectionStatus.get() == 2) {
                            PacketData packetData = (PacketData)AbstractIpConnection.this.packetsToSend.take();
                            ICommandListener listener = packetData.listener;
                            try {
                                AbstractIpConnection.this.send(packetData);
                                this.postSendSuccess(listener);
                                continue block7;
                            }
                            catch (IOException e) {
                                Log.e((String)TAG, (String)"Error occurred while sending packet.", (Throwable)e);
                                this.postSendTimeout(listener);
                            }
                        }
                        break block9;
                    }
                    catch (InterruptedException e) {
                        Log.e((String)TAG, (String)"Dispatching thread was interrupted.", (Throwable)e);
                        break block9;
                    }
                }
                finally {
                    AbstractIpConnection.this.disconnect();
                    Log.i((String)TAG, (String)"Exiting packet dispatcher thread.");
                }
            }
        }

        private void postSendSuccess(final ICommandListener listener) {
            if (AbstractIpConnection.this.handler == null || listener == null) {
                return;
            }
            AbstractIpConnection.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onSuccess();
                    }
                    catch (RemoteException e) {
                        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }

        private void postSendTimeout(final ICommandListener listener) {
            if (AbstractIpConnection.this.handler == null || listener == null) {
                return;
            }
            AbstractIpConnection.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onTimeout();
                    }
                    catch (RemoteException e) {
                        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    };
    private final boolean isPolling;
    private final Handler handler;
    private Thread managerThread;

    public AbstractIpConnection(Handler handler) {
        this(handler, false, false);
    }

    public AbstractIpConnection(Handler handler, int readBufferSize, boolean isPolling) {
        this(handler, readBufferSize, false, false, isPolling);
    }

    public AbstractIpConnection(Handler handler, boolean disableSending, boolean disableReading) {
        this(handler, 4096, disableSending, disableReading, false);
    }

    public AbstractIpConnection(Handler handler, int readBufferSize, boolean disableSending, boolean disableReading, boolean isPolling) {
        this.handler = handler;
        this.readBuffer = ByteBuffer.allocate(readBufferSize);
        this.isReadingDisabled = disableReading;
        this.isSendingDisabled = disableSending;
        this.isPolling = isPolling;
    }

    protected abstract void open() throws IOException;

    protected abstract int read(ByteBuffer var1) throws IOException;

    protected abstract void send(PacketData var1) throws IOException;

    protected abstract void close() throws IOException;

    public void connect() {
        if (this.connectionStatus.compareAndSet(0, 1)) {
            Log.i((String)TAG, (String)"Starting manager thread.");
            this.managerThread = new Thread(this.managerTask, "IP Connection-Manager Thread");
            this.managerThread.setPriority(10);
            this.managerThread.start();
        }
    }

    public void disconnect() {
        if (this.connectionStatus.get() == 0 || this.managerThread == null) {
            return;
        }
        this.connectionStatus.set(0);
        if (this.managerThread != null && this.managerThread.isAlive() && !this.managerThread.isInterrupted()) {
            this.managerThread.interrupt();
        }
        try {
            this.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error occurred while closing ip connection.", (Throwable)e);
        }
        if (this.ipConnectionListener != null) {
            this.ipConnectionListener.onIpDisconnected();
        }
    }

    public void setIpConnectionListener(IpConnectionListener ipConnectionListener) {
        this.ipConnectionListener = ipConnectionListener;
    }

    public void sendPacket(byte[] packet, int packetSize, ICommandListener listener) {
        if (packet == null || packetSize <= 0) {
            return;
        }
        this.packetsToSend.offer(new PacketData(packetSize, packet, listener));
    }

    public int getConnectionStatus() {
        return this.connectionStatus.get();
    }

    protected static final class PacketData {
        public final int dataLength;
        public final byte[] data;
        public final ICommandListener listener;

        public PacketData(int dataLength, byte[] data, ICommandListener listener) {
            this.dataLength = dataLength;
            this.data = data;
            this.listener = listener;
        }
    }
}

