/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.o3dr.android.client.utils.InstallServiceDialog;
import com.o3dr.services.android.lib.model.IDroidPlannerServices;
import com.o3dr.services.android.lib.util.version.VersionUtils;

public class ApiAvailability {
    private static final String TAG = ApiAvailability.class.getSimpleName();
    private static final String SERVICES_CLAZZ_NAME = IDroidPlannerServices.class.getName();
    private static final String METADATA_KEY = "com.o3dr.dronekit.android.core.version";
    public static final int API_AVAILABLE = 0;
    public static final int API_MISSING = 1;
    public static final int API_UPDATE_REQUIRED = 2;

    private ApiAvailability() {
    }

    public static ApiAvailability getInstance() {
        return LazyHolder.INSTANCE;
    }

    public int checkApiAvailability(@NonNull Context context) {
        Intent serviceIntent;
        PackageManager pm = context.getPackageManager();
        ResolveInfo serviceInfo = pm.resolveService(serviceIntent = new Intent(SERVICES_CLAZZ_NAME), 128);
        if (serviceInfo == null) {
            return 1;
        }
        Bundle metaData = serviceInfo.serviceInfo.metaData;
        if (metaData == null) {
            return 2;
        }
        int coreLibVersion = metaData.getInt(METADATA_KEY);
        if (coreLibVersion < VersionUtils.getCoreLibVersion(context)) {
            return 2;
        }
        return 0;
    }

    public void showErrorDialog(Context context, int errorCode) {
        switch (errorCode) {
            case 1: {
                context.startActivity(new Intent(context, InstallServiceDialog.class).addFlags(0x10000000).putExtra("extra_requirement", 0));
                break;
            }
            case 2: {
                context.startActivity(new Intent(context, InstallServiceDialog.class).addFlags(0x10000000).putExtra("extra_requirement", 1));
            }
        }
    }

    private static class LazyHolder {
        private static final ApiAvailability INSTANCE = new ApiAvailability();

        private LazyHolder() {
        }
    }
}

