/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl;

import com.nytimes.android.external.store3.base.DiskRead;
import com.nytimes.android.external.store3.base.DiskWrite;
import com.nytimes.android.external.store3.base.Fetcher;
import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.base.Persister;
import com.nytimes.android.external.store3.base.impl.MemoryPolicy;
import com.nytimes.android.external.store3.base.impl.MultiParser;
import com.nytimes.android.external.store3.base.impl.RealInternalStore;
import com.nytimes.android.external.store3.base.impl.RealStore;
import com.nytimes.android.external.store3.base.impl.StalePolicy;
import com.nytimes.android.external.store3.base.impl.Store;
import com.nytimes.android.external.store3.util.KeyParser;
import com.nytimes.android.external.store3.util.NoKeyParser;
import com.nytimes.android.external.store3.util.NoopParserFunc;
import com.nytimes.android.external.store3.util.NoopPersister;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class RealStoreBuilder<Raw, Parsed, Key> {
    private final List<KeyParser> parsers = new ArrayList<KeyParser>();
    private Persister<Raw, Key> persister;
    private Fetcher<Raw, Key> fetcher;
    private MemoryPolicy memoryPolicy;
    private StalePolicy stalePolicy = StalePolicy.UNSPECIFIED;

    @Nonnull
    public static <Raw, Parsed, Key> RealStoreBuilder<Raw, Parsed, Key> builder() {
        return new RealStoreBuilder<Raw, Parsed, Key>();
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> fetcher(@Nonnull Fetcher<Raw, Key> fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> persister(@Nonnull Persister<Raw, Key> persister) {
        this.persister = persister;
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> persister(final @Nonnull DiskRead<Raw, Key> diskRead, final @Nonnull DiskWrite<Raw, Key> diskWrite) {
        this.persister = new Persister<Raw, Key>(){

            @Override
            @Nonnull
            public Maybe<Raw> read(@Nonnull Key key) {
                return diskRead.read(key);
            }

            @Override
            @Nonnull
            public Single<Boolean> write(@Nonnull Key key, @Nonnull Raw raw) {
                return diskWrite.write(key, raw);
            }
        };
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> parser(@Nonnull Parser<Raw, Parsed> parser) {
        this.parsers.clear();
        this.parsers.add(new NoKeyParser(parser));
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> parser(@Nonnull KeyParser<Key, Raw, Parsed> parser) {
        this.parsers.clear();
        this.parsers.add(parser);
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> parsers(@Nonnull List<Parser> parsers) {
        this.parsers.clear();
        for (Parser parser : parsers) {
            this.parsers.add(new NoKeyParser(parser));
        }
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> memoryPolicy(MemoryPolicy memoryPolicy) {
        this.memoryPolicy = memoryPolicy;
        return this;
    }

    public RealStoreBuilder<Raw, Parsed, Key> refreshOnStale() {
        this.stalePolicy = StalePolicy.REFRESH_ON_STALE;
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> networkBeforeStale() {
        this.stalePolicy = StalePolicy.NETWORK_BEFORE_STALE;
        return this;
    }

    @Nonnull
    public Store<Parsed, Key> open() {
        if (this.persister == null) {
            this.persister = NoopPersister.create(this.memoryPolicy);
        }
        if (this.parsers.isEmpty()) {
            this.parser(new NoopParserFunc());
        }
        MultiParser multiParser = new MultiParser(this.parsers);
        RealInternalStore realInternalStore = new RealInternalStore(this.fetcher, this.persister, multiParser, this.memoryPolicy, this.stalePolicy);
        return new RealStore(realInternalStore);
    }
}

