/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl;

import com.nytimes.android.external.store.util.Result;
import com.nytimes.android.external.store3.base.Fetcher;
import com.nytimes.android.external.store3.base.InternalStore;
import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.base.Persister;
import com.nytimes.android.external.store3.base.impl.MemoryPolicy;
import com.nytimes.android.external.store3.base.impl.RealInternalStore;
import com.nytimes.android.external.store3.base.impl.StalePolicy;
import com.nytimes.android.external.store3.base.impl.Store;
import com.nytimes.android.external.store3.util.KeyParser;
import com.nytimes.android.external.store3.util.NoKeyParser;
import com.nytimes.android.external.store3.util.NoopParserFunc;
import com.nytimes.android.external.store3.util.NoopPersister;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import javax.annotation.Nonnull;

public class RealStore<Parsed, Key>
implements Store<Parsed, Key> {
    private final InternalStore<Parsed, Key> internalStore;

    public RealStore(InternalStore<Parsed, Key> internalStore) {
        this.internalStore = internalStore;
    }

    public RealStore(Fetcher<Parsed, Key> fetcher) {
        NoopParserFunc noOpFunc = new NoopParserFunc();
        this.internalStore = new RealInternalStore(fetcher, NoopPersister.create(), new NoKeyParser(noOpFunc), StalePolicy.UNSPECIFIED);
    }

    public RealStore(Fetcher<Parsed, Key> fetcher, Persister<Parsed, Key> persister) {
        NoopParserFunc noOpFunc = new NoopParserFunc();
        this.internalStore = new RealInternalStore(fetcher, persister, new NoKeyParser(noOpFunc), StalePolicy.UNSPECIFIED);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, Parser<Raw, Parsed> parser) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, new NoKeyParser(parser), StalePolicy.UNSPECIFIED);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, Parser<Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy policy) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, new NoKeyParser(parser), memoryPolicy, policy);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy policy) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, parser, memoryPolicy, policy);
    }

    @Override
    @Nonnull
    public Single<Parsed> get(@Nonnull Key key) {
        return this.internalStore.get(key);
    }

    @Override
    @Nonnull
    public Single<Result<Parsed>> getWithResult(@Nonnull Key key) {
        return this.internalStore.getWithResult(key);
    }

    @Override
    public Observable<Parsed> getRefreshing(@Nonnull Key key) {
        return this.internalStore.getRefreshing(key);
    }

    @Override
    @Nonnull
    public Single<Parsed> fetch(@Nonnull Key key) {
        return this.internalStore.fetch(key);
    }

    @Override
    @Nonnull
    public Single<Result<Parsed>> fetchWithResult(@Nonnull Key key) {
        return this.internalStore.fetchWithResult(key);
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream() {
        return this.internalStore.stream();
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream(Key key) {
        return this.internalStore.stream(key);
    }

    @Override
    public void clearMemory() {
        this.internalStore.clearMemory();
    }

    @Override
    public void clearMemory(@Nonnull Key key) {
        this.internalStore.clearMemory(key);
    }

    @Override
    public void clear() {
        this.internalStore.clear();
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.internalStore.clear(key);
    }

    protected Maybe<Parsed> memory(@Nonnull Key key) {
        return this.internalStore.memory(key);
    }

    @Nonnull
    protected Maybe<Parsed> disk(@Nonnull Key key) {
        return this.internalStore.disk(key);
    }
}

