/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.util;

public final class Result<Parsed> {
    private final Source source;
    private final Parsed value;

    private Result(Source source, Parsed value) {
        this.source = source;
        this.value = value;
    }

    public static <T> Result<T> createFromCache(T value) {
        return new Result<T>(Source.CACHE, value);
    }

    public static <T> Result<T> createFromNetwork(T value) {
        return new Result<T>(Source.NETWORK, value);
    }

    public Source source() {
        return this.source;
    }

    public Parsed value() {
        return this.value;
    }

    public boolean isFromNetwork() {
        return this.source == Source.NETWORK;
    }

    public boolean isFromCache() {
        return this.source == Source.CACHE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (this.source != null && !this.source.equals((Object)result.source)) {
            return false;
        }
        if (this.source == null && result.source != null) {
            return false;
        }
        if (this.value != null) {
            return this.value.equals(result.value);
        }
        return result.value == null;
    }

    public int hashCode() {
        int result = 0;
        if (this.source != null) {
            result = this.source.hashCode();
        }
        result = 31 * result;
        if (this.value != null) {
            result += this.value.hashCode();
        }
        return result;
    }

    public static enum Source {
        CACHE,
        NETWORK;

    }
}

