/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl;

import com.nytimes.android.external.cache3.Cache;
import com.nytimes.android.external.store3.base.Fetcher;
import com.nytimes.android.external.store3.base.InternalStore;
import com.nytimes.android.external.store3.base.Persister;
import com.nytimes.android.external.store3.base.impl.CacheFactory;
import com.nytimes.android.external.store3.base.impl.MemoryPolicy;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$1;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$10;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$11;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$12;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$13;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$2;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$3;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$4;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$5;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$6;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$7;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$8;
import com.nytimes.android.external.store3.base.impl.RealInternalStore$$Lambda$9;
import com.nytimes.android.external.store3.base.impl.StalePolicy;
import com.nytimes.android.external.store3.base.impl.StoreUtil;
import com.nytimes.android.external.store3.util.KeyParser;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.annotations.Experimental;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RealInternalStore<Raw, Parsed, Key>
implements InternalStore<Parsed, Key> {
    Cache<Key, Single<Parsed>> inFlightRequests;
    Cache<Key, Maybe<Parsed>> memCache;
    StalePolicy stalePolicy;
    Persister<Raw, Key> persister;
    KeyParser<Key, Raw, Parsed> parser;
    private final PublishSubject<Key> refreshSubject = PublishSubject.create();
    private Fetcher<Raw, Key> fetcher;
    private PublishSubject<Parsed> subject;

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, StalePolicy stalePolicy) {
        this(fetcher, persister, parser, null, stalePolicy);
    }

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy stalePolicy) {
        this.fetcher = fetcher;
        this.persister = persister;
        this.parser = parser;
        this.stalePolicy = stalePolicy;
        this.memCache = CacheFactory.createCache(memoryPolicy);
        this.inFlightRequests = CacheFactory.createInflighter(memoryPolicy);
        this.subject = PublishSubject.create();
    }

    @Override
    @Nonnull
    public Single<Parsed> get(@Nonnull Key key) {
        return this.lazyCache(key).switchIfEmpty((MaybeSource)this.fetch(key).toMaybe()).toSingle();
    }

    @Override
    @Nonnull
    @Experimental
    public Observable<Parsed> getRefreshing(@Nonnull Key key) {
        return this.get(key).toObservable().compose(StoreUtil.repeatWhenCacheEvicted(this.refreshSubject, key));
    }

    private Maybe<Parsed> lazyCache(@Nonnull Key key) {
        return Maybe.defer((Callable)RealInternalStore$$Lambda$1.lambdaFactory$(this, key)).onErrorResumeNext((MaybeSource)Maybe.empty());
    }

    Maybe<Parsed> cache(@Nonnull Key key) {
        try {
            return (Maybe)this.memCache.get(key, RealInternalStore$$Lambda$2.lambdaFactory$(this, key));
        }
        catch (ExecutionException e) {
            return Maybe.empty();
        }
    }

    @Override
    @Nonnull
    public Maybe<Parsed> memory(@Nonnull Key key) {
        Maybe cachedValue = (Maybe)this.memCache.getIfPresent(key);
        return cachedValue == null ? Maybe.empty() : cachedValue;
    }

    @Override
    @Nonnull
    public Maybe<Parsed> disk(@Nonnull Key key) {
        if (StoreUtil.shouldReturnNetworkBeforeStale(this.persister, this.stalePolicy, key)) {
            return Maybe.empty();
        }
        return this.readDisk(key);
    }

    Maybe<Parsed> readDisk(@Nonnull Key key) {
        return this.persister().read(key).onErrorResumeNext((MaybeSource)Maybe.empty()).map(RealInternalStore$$Lambda$3.lambdaFactory$(this, key)).doOnSuccess(RealInternalStore$$Lambda$4.lambdaFactory$(this, key)).cache();
    }

    void backfillCache(@Nonnull Key key) {
        this.fetch(key).subscribe(RealInternalStore$$Lambda$5.lambdaFactory$(), RealInternalStore$$Lambda$6.lambdaFactory$());
    }

    @Override
    @Nonnull
    public Single<Parsed> fetch(@Nonnull Key key) {
        return Single.defer((Callable)RealInternalStore$$Lambda$7.lambdaFactory$(this, key));
    }

    @Nullable
    Single<Parsed> fetchAndPersist(@Nonnull Key key) {
        try {
            return (Single)this.inFlightRequests.get(key, RealInternalStore$$Lambda$8.lambdaFactory$(this, key));
        }
        catch (ExecutionException e) {
            return Single.error((Throwable)e);
        }
    }

    @Nonnull
    Single<Parsed> response(@Nonnull Key key) {
        return this.fetcher().fetch(key).flatMap(RealInternalStore$$Lambda$9.lambdaFactory$(this, key)).onErrorResumeNext(RealInternalStore$$Lambda$10.lambdaFactory$(this, key)).doOnSuccess(RealInternalStore$$Lambda$11.lambdaFactory$(this)).doAfterTerminate(RealInternalStore$$Lambda$12.lambdaFactory$(this, key)).cache();
    }

    void notifySubscribers(Parsed data) {
        this.subject.onNext(data);
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream(@Nonnull Key key) {
        return this.subject.hide().startWith((ObservableSource)this.get(key).toObservable());
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream() {
        return this.subject.hide();
    }

    void updateMemory(@Nonnull Key key, Parsed data) {
        this.memCache.put(key, (Object)Maybe.just(data));
    }

    @Override
    @Deprecated
    public void clearMemory() {
        this.clear();
    }

    @Override
    @Deprecated
    public void clearMemory(@Nonnull Key key) {
        this.clear(key);
    }

    @Override
    public void clear() {
        for (Object cachedKey : this.memCache.asMap().keySet()) {
            this.clear((Key)cachedKey);
        }
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.inFlightRequests.invalidate(key);
        this.memCache.invalidate(key);
        StoreUtil.clearPersister(this.persister(), key);
        this.notifyRefresh(key);
    }

    private void notifyRefresh(@Nonnull Key key) {
        this.refreshSubject.onNext(key);
    }

    Persister<Raw, Key> persister() {
        return this.persister;
    }

    Fetcher<Raw, Key> fetcher() {
        return this.fetcher;
    }

    static /* synthetic */ void lambda$response$11(@Nonnull RealInternalStore this_, Object key) throws Exception {
        this_.inFlightRequests.invalidate(key);
    }

    static /* synthetic */ SingleSource lambda$response$10(@Nonnull RealInternalStore this_, Object key, Throwable throwable) throws Exception {
        if (this_.stalePolicy == StalePolicy.NETWORK_BEFORE_STALE) {
            return this_.readDisk(key).switchIfEmpty((MaybeSource)Maybe.error((Throwable)throwable)).toSingle();
        }
        return Single.error((Throwable)throwable);
    }

    static /* synthetic */ SingleSource lambda$response$9(@Nonnull RealInternalStore this_, Object key, Object raw) throws Exception {
        return this_.persister().write(key, raw).flatMap(RealInternalStore$$Lambda$13.lambdaFactory$(this_, key));
    }

    static /* synthetic */ SingleSource lambda$null$8(@Nonnull RealInternalStore this_, Object key, Boolean aBoolean) throws Exception {
        return this_.readDisk(key).toSingle();
    }

    static /* synthetic */ Single lambda$fetchAndPersist$7(@Nonnull RealInternalStore this_, Object key) throws Exception {
        return this_.response(key);
    }

    static /* synthetic */ SingleSource lambda$fetch$6(@Nonnull RealInternalStore this_, Object key) throws Exception {
        return this_.fetchAndPersist(key);
    }

    static /* synthetic */ void lambda$backfillCache$5(Throwable throwable) throws Exception {
    }

    static /* synthetic */ void lambda$backfillCache$4(Object parsed) throws Exception {
    }

    static /* synthetic */ void lambda$readDisk$3(@Nonnull RealInternalStore this_, Object key, Object parsed) throws Exception {
        this_.updateMemory(key, parsed);
        if (this_.stalePolicy == StalePolicy.REFRESH_ON_STALE && StoreUtil.persisterIsStale(key, this_.persister)) {
            this_.backfillCache(key);
        }
    }

    static /* synthetic */ Object lambda$readDisk$2(@Nonnull RealInternalStore this_, Object key, Object raw) throws Exception {
        return this_.parser.apply(key, raw);
    }

    static /* synthetic */ Maybe lambda$cache$1(@Nonnull RealInternalStore this_, Object key) throws Exception {
        return this_.disk(key);
    }

    static /* synthetic */ MaybeSource lambda$lazyCache$0(@Nonnull RealInternalStore this_, Object key) throws Exception {
        return this_.cache(key);
    }
}

