/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl;

import com.nytimes.android.external.cache3.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class BarCode
implements Serializable {
    private static final BarCode EMPTY_BARCODE = new BarCode("", "");
    @Nonnull
    private final String key;
    @Nonnull
    private final String type;

    public BarCode(@Nonnull String type, @Nonnull String key) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.type = (String)Preconditions.checkNotNull((Object)type);
    }

    @Nonnull
    public static BarCode empty() {
        return EMPTY_BARCODE;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BarCode)) {
            return false;
        }
        BarCode barCode = (BarCode)object;
        if (!this.key.equals(barCode.key)) {
            return false;
        }
        return this.type.equals(barCode.type);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "BarCode{key='" + this.key + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

