/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.util;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.store.base.Clearable;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.MemoryPolicy;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import rx.Observable;

public class NoopPersister<Raw, Key>
implements Persister<Raw, Key>,
Clearable<Key> {
    protected final Cache<Key, Observable<Raw>> networkResponses;

    NoopPersister(MemoryPolicy memoryPolicy) {
        this.networkResponses = CacheBuilder.newBuilder().expireAfterWrite(memoryPolicy.getExpireAfterWrite(), memoryPolicy.getExpireAfterTimeUnit()).build();
    }

    public static <Raw, Key> NoopPersister<Raw, Key> create() {
        return NoopPersister.create(null);
    }

    public static <Raw, Key> NoopPersister<Raw, Key> create(MemoryPolicy memoryPolicy) {
        MemoryPolicy memPolicy = memoryPolicy == null ? MemoryPolicy.builder().setExpireAfterWrite(TimeUnit.HOURS.toSeconds(24L)).setExpireAfterTimeUnit(TimeUnit.SECONDS).build() : memoryPolicy;
        return new NoopPersister<Raw, Key>(memPolicy);
    }

    @Override
    @Nonnull
    public Observable<Raw> read(@Nonnull Key key) {
        Observable cachedValue = (Observable)this.networkResponses.getIfPresent(key);
        return cachedValue == null ? Observable.error((Throwable)new FileNotFoundException()) : cachedValue;
    }

    @Override
    @Nonnull
    public Observable<Boolean> write(@Nonnull Key key, @Nonnull Raw raw) {
        this.networkResponses.put(key, (Object)Observable.just(raw));
        return Observable.just((Object)true);
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.networkResponses.invalidate(key);
    }
}

