/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.store.util.KeyParser;
import com.nytimes.android.external.store.util.ParserException;
import java.util.ArrayList;
import java.util.List;

public class MultiParser<Key, Raw, Parsed>
implements KeyParser<Key, Raw, Parsed> {
    private final List<KeyParser> parsers = new ArrayList<KeyParser>();

    public MultiParser(List<KeyParser> parsers) {
        Preconditions.checkNotNull(parsers, (String)"Parsers can't be null.");
        Preconditions.checkArgument((!parsers.isEmpty() ? 1 : 0) != 0, (Object)"Parsers can't be empty.");
        for (KeyParser parser : parsers) {
            Preconditions.checkNotNull((Object)parser, (String)"Parser can't be null.");
        }
        this.parsers.addAll(parsers);
    }

    private ParserException createParserException() {
        return new ParserException("One of the provided parsers has a wrong typing. Make sure that parsers are passed in a correct order and the fromTypes match each other.");
    }

    @Override
    public Parsed call(Key key, Raw raw) {
        Object parsed = raw;
        for (KeyParser parser : this.parsers) {
            try {
                parsed = parser.call(key, parsed);
            }
            catch (ClassCastException exception) {
                throw this.createParserException();
            }
        }
        return (Parsed)parsed;
    }
}

