/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.store.base.Clearable;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.RecordProvider;
import com.nytimes.android.external.store.base.RecordState;
import com.nytimes.android.external.store.base.impl.RepeatWhenEmits;
import com.nytimes.android.external.store.base.impl.StalePolicy;
import com.nytimes.android.external.store.base.impl.StoreUtil$$Lambda$1;
import javax.annotation.Nonnull;
import rx.Observable;
import rx.subjects.PublishSubject;

final class StoreUtil {
    private StoreUtil() {
    }

    @Nonnull
    static <Parsed, Key> Observable.Transformer<Parsed, Parsed> repeatWhenCacheEvicted(PublishSubject<Key> refreshSubject, @Nonnull Key keyForRepeat) {
        Observable filter = refreshSubject.filter(StoreUtil$$Lambda$1.lambdaFactory$(keyForRepeat));
        return RepeatWhenEmits.from(filter);
    }

    static <Raw, Key> boolean shouldReturnNetworkBeforeStale(Persister<Raw, Key> persister, StalePolicy stalePolicy, Key key) {
        return stalePolicy == StalePolicy.NETWORK_BEFORE_STALE && StoreUtil.persisterIsStale(key, persister);
    }

    static <Raw, Key> boolean persisterIsStale(@Nonnull Key key, Persister<Raw, Key> persister) {
        if (persister instanceof RecordProvider) {
            RecordProvider provider = (RecordProvider)((Object)persister);
            RecordState recordState = provider.getRecordState(key);
            return recordState == RecordState.STALE;
        }
        return false;
    }

    static <Raw, Key> void clearPersister(Persister<Raw, Key> persister, @Nonnull Key key) {
        boolean isPersisterClearable = persister instanceof Clearable;
        if (isPersisterClearable) {
            ((Clearable)((Object)persister)).clear(key);
        }
    }

    static /* synthetic */ Boolean lambda$repeatWhenCacheEvicted$0(@Nonnull Object keyForRepeat, Object key) {
        return key.equals(keyForRepeat);
    }
}

