/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.InternalStore;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.CacheFactory;
import com.nytimes.android.external.store.base.impl.MemoryPolicy;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$1;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$10;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$11;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$12;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$13;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$14;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$2;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$3;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$4;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$5;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$6;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$7;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$8;
import com.nytimes.android.external.store.base.impl.RealInternalStore$$Lambda$9;
import com.nytimes.android.external.store.base.impl.StalePolicy;
import com.nytimes.android.external.store.base.impl.StoreUtil;
import com.nytimes.android.external.store.util.KeyParser;
import com.nytimes.android.external.store.util.OnErrorResumeWithEmpty;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rx.Observable;
import rx.annotations.Experimental;
import rx.functions.Func0;
import rx.subjects.PublishSubject;

final class RealInternalStore<Raw, Parsed, Key>
implements InternalStore<Parsed, Key> {
    Cache<Key, Observable<Parsed>> inFlightRequests;
    Cache<Key, Observable<Parsed>> memCache;
    Persister<Raw, Key> persister;
    KeyParser<Key, Raw, Parsed> parser;
    StalePolicy stalePolicy;
    private final PublishSubject<Key> refreshSubject = PublishSubject.create();
    private Fetcher<Raw, Key> fetcher;
    private PublishSubject<Parsed> subject;

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, StalePolicy stalePolicy) {
        this(fetcher, persister, parser, null, stalePolicy);
    }

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy stalePolicy) {
        this.fetcher = fetcher;
        this.persister = persister;
        this.parser = parser;
        this.stalePolicy = stalePolicy;
        this.memCache = CacheFactory.createCache(memoryPolicy);
        this.inFlightRequests = CacheFactory.createInflighter(memoryPolicy);
        this.subject = PublishSubject.create();
    }

    @Override
    @Nonnull
    public Observable<Parsed> get(@Nonnull Key key) {
        return Observable.concat(this.lazyCache(key), this.fetch(key)).take(1);
    }

    @Override
    @Nonnull
    @Experimental
    public Observable<Parsed> getRefreshing(@Nonnull Key key) {
        return this.get(key).compose(StoreUtil.repeatWhenCacheEvicted(this.refreshSubject, key));
    }

    private Observable<Parsed> lazyCache(@Nonnull Key key) {
        return Observable.defer((Func0)RealInternalStore$$Lambda$1.lambdaFactory$(this, key)).onErrorResumeNext(new OnErrorResumeWithEmpty());
    }

    Observable<Parsed> cache(@Nonnull Key key) {
        try {
            return (Observable)this.memCache.get(key, RealInternalStore$$Lambda$2.lambdaFactory$(this, key));
        }
        catch (ExecutionException e) {
            return Observable.empty();
        }
    }

    @Override
    @Nonnull
    public Observable<Parsed> memory(@Nonnull Key key) {
        Observable cachedValue = (Observable)this.memCache.getIfPresent(key);
        return cachedValue == null ? Observable.empty() : cachedValue;
    }

    @Override
    @Nonnull
    public Observable<Parsed> disk(@Nonnull Key key) {
        if (StoreUtil.shouldReturnNetworkBeforeStale(this.persister, this.stalePolicy, key)) {
            return Observable.empty();
        }
        return this.readDisk(key);
    }

    Observable<Parsed> readDisk(@Nonnull Key key) {
        return this.readDisk(key, null);
    }

    Observable<Parsed> readDisk(@Nonnull Key key, Throwable error) {
        return this.persister().read(key).onErrorResumeNext(RealInternalStore$$Lambda$3.lambdaFactory$(error)).map(RealInternalStore$$Lambda$4.lambdaFactory$(this, key)).doOnNext(RealInternalStore$$Lambda$5.lambdaFactory$(this, key)).cache();
    }

    void backfillCache(@Nonnull Key key) {
        this.fetch(key).subscribe(RealInternalStore$$Lambda$6.lambdaFactory$(), RealInternalStore$$Lambda$7.lambdaFactory$());
    }

    @Override
    @Nonnull
    public Observable<Parsed> fetch(@Nonnull Key key) {
        return Observable.defer((Func0)RealInternalStore$$Lambda$8.lambdaFactory$(this, key));
    }

    @Nullable
    Observable<Parsed> fetchAndPersist(@Nonnull Key key) {
        try {
            return (Observable)this.inFlightRequests.get(key, RealInternalStore$$Lambda$9.lambdaFactory$(this, key));
        }
        catch (ExecutionException e) {
            return Observable.empty();
        }
    }

    @Nonnull
    Observable<Parsed> response(@Nonnull Key key) {
        return this.fetcher().fetch(key).flatMap(RealInternalStore$$Lambda$10.lambdaFactory$(this, key)).onErrorResumeNext(RealInternalStore$$Lambda$11.lambdaFactory$(this, key)).doOnNext(RealInternalStore$$Lambda$12.lambdaFactory$(this)).doOnTerminate(RealInternalStore$$Lambda$13.lambdaFactory$(this, key)).cache();
    }

    void notifySubscribers(Parsed data) {
        this.subject.onNext(data);
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream(@Nonnull Key key) {
        return this.subject.startWith(this.get(key));
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream() {
        return this.subject.asObservable();
    }

    void updateMemory(@Nonnull Key key, Parsed data) {
        this.memCache.put(key, (Object)Observable.just(data));
    }

    @Override
    @Deprecated
    public void clearMemory() {
        this.clear();
    }

    @Override
    @Deprecated
    public void clearMemory(@Nonnull Key key) {
        this.clear(key);
    }

    @Override
    public void clear() {
        for (Object cachedKey : this.memCache.asMap().keySet()) {
            this.clear((Key)cachedKey);
        }
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.inFlightRequests.invalidate(key);
        this.memCache.invalidate(key);
        StoreUtil.clearPersister(this.persister(), key);
        this.notifyRefresh(key);
    }

    private void notifyRefresh(@Nonnull Key key) {
        this.refreshSubject.onNext(key);
    }

    Persister<Raw, Key> persister() {
        return this.persister;
    }

    Fetcher<Raw, Key> fetcher() {
        return this.fetcher;
    }

    static /* synthetic */ void lambda$response$12(@Nonnull RealInternalStore this_, Object key) {
        this_.inFlightRequests.invalidate(key);
    }

    static /* synthetic */ Observable lambda$response$11(@Nonnull RealInternalStore this_, Object key, Throwable throwable) {
        if (this_.stalePolicy == StalePolicy.NETWORK_BEFORE_STALE) {
            return this_.readDisk(key, throwable);
        }
        return Observable.error((Throwable)throwable);
    }

    static /* synthetic */ Observable lambda$response$10(@Nonnull RealInternalStore this_, Object key, Object raw) {
        return this_.persister().write(key, raw).flatMap(RealInternalStore$$Lambda$14.lambdaFactory$(this_, key));
    }

    static /* synthetic */ Observable lambda$null$9(@Nonnull RealInternalStore this_, Object key, Boolean aBoolean) {
        return this_.readDisk(key);
    }

    static /* synthetic */ Observable lambda$fetchAndPersist$8(@Nonnull RealInternalStore this_, Object key) throws Exception {
        return this_.response(key);
    }

    static /* synthetic */ Observable lambda$fetch$7(@Nonnull RealInternalStore this_, Object key) {
        return this_.fetchAndPersist(key);
    }

    static /* synthetic */ void lambda$backfillCache$6(Throwable throwable) {
    }

    static /* synthetic */ void lambda$backfillCache$5(Object parsed) {
    }

    static /* synthetic */ void lambda$readDisk$4(@Nonnull RealInternalStore this_, Object key, Object parsed) {
        this_.updateMemory(key, parsed);
        if (this_.stalePolicy == StalePolicy.REFRESH_ON_STALE && StoreUtil.persisterIsStale(key, this_.persister)) {
            this_.backfillCache(key);
        }
    }

    static /* synthetic */ Object lambda$readDisk$3(@Nonnull RealInternalStore this_, Object key, Object raw) {
        return this_.parser.call(key, raw);
    }

    static /* synthetic */ Observable lambda$readDisk$2(Throwable error, Throwable throwable) {
        if (error == null) {
            return Observable.empty();
        }
        return Observable.error((Throwable)error);
    }

    static /* synthetic */ Observable lambda$cache$1(@Nonnull RealInternalStore this_, Object key) throws Exception {
        return this_.disk(key);
    }

    static /* synthetic */ Observable lambda$lazyCache$0(@Nonnull RealInternalStore this_, Object key) {
        return this_.cache(key);
    }
}

