/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import java.util.concurrent.TimeUnit;

public class MemoryPolicy {
    public static final long DEFAULT_POLICY = -1L;
    private final long expireAfterWrite;
    private final long expireAfterAccess;
    private final TimeUnit expireAfterTimeUnit;
    private final long maxSize;

    MemoryPolicy(long expireAfterWrite, long expireAfterAccess, TimeUnit expireAfterTimeUnit, long maxSize) {
        this.expireAfterWrite = expireAfterWrite;
        this.expireAfterAccess = expireAfterAccess;
        this.expireAfterTimeUnit = expireAfterTimeUnit;
        this.maxSize = maxSize;
    }

    public static MemoryPolicyBuilder builder() {
        return new MemoryPolicyBuilder();
    }

    @Deprecated
    public long getExpireAfter() {
        return this.expireAfterWrite;
    }

    public long getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public long getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    public TimeUnit getExpireAfterTimeUnit() {
        return this.expireAfterTimeUnit;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public boolean isDefaultPolicy() {
        return this.expireAfterWrite == -1L;
    }

    public static class MemoryPolicyBuilder {
        private long expireAfterWrite = -1L;
        private long expireAfterAccess = -1L;
        private TimeUnit expireAfterTimeUnit = TimeUnit.SECONDS;
        private long maxSize = 1L;

        @Deprecated
        public MemoryPolicyBuilder setExpireAfter(long expireAfter) {
            return this.setExpireAfterWrite(expireAfter);
        }

        public MemoryPolicyBuilder setExpireAfterWrite(long expireAfterWrite) {
            if (this.expireAfterAccess != -1L) {
                throw new IllegalStateException("Cannot set expireAfterWrite with expireAfterAccess already set");
            }
            this.expireAfterWrite = expireAfterWrite;
            return this;
        }

        public MemoryPolicyBuilder setExpireAfterAccess(long expireAfterAccess) {
            if (this.expireAfterWrite != -1L) {
                throw new IllegalStateException("Cannot set expireAfterAccess with expireAfterWrite already set");
            }
            this.expireAfterAccess = expireAfterAccess;
            return this;
        }

        public MemoryPolicyBuilder setExpireAfterTimeUnit(TimeUnit expireAfterTimeUnit) {
            this.expireAfterTimeUnit = expireAfterTimeUnit;
            return this;
        }

        public MemoryPolicyBuilder setMemorySize(long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public MemoryPolicy build() {
            return new MemoryPolicy(this.expireAfterWrite, this.expireAfterAccess, this.expireAfterTimeUnit, this.maxSize);
        }
    }
}

