/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.InternalStore;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.MemoryPolicy;
import com.nytimes.android.external.store.base.impl.RealInternalStore;
import com.nytimes.android.external.store.base.impl.StalePolicy;
import com.nytimes.android.external.store.base.impl.Store;
import com.nytimes.android.external.store.util.KeyParser;
import com.nytimes.android.external.store.util.NoKeyParser;
import com.nytimes.android.external.store.util.NoopParserFunc;
import com.nytimes.android.external.store.util.NoopPersister;
import javax.annotation.Nonnull;
import rx.Observable;

public class RealStore<Parsed, Key>
implements Store<Parsed, Key> {
    private final InternalStore<Parsed, Key> internalStore;

    public RealStore(InternalStore<Parsed, Key> internalStore) {
        this.internalStore = internalStore;
    }

    public RealStore(Fetcher<Parsed, Key> fetcher) {
        NoopParserFunc noOpFunc = new NoopParserFunc();
        this.internalStore = new RealInternalStore(fetcher, NoopPersister.create(), new NoKeyParser(noOpFunc), StalePolicy.UNSPECIFIED);
    }

    public RealStore(Fetcher<Parsed, Key> fetcher, Persister<Parsed, Key> persister) {
        NoopParserFunc noOpFunc = new NoopParserFunc();
        this.internalStore = new RealInternalStore(fetcher, persister, new NoKeyParser(noOpFunc), StalePolicy.UNSPECIFIED);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, Parser<Raw, Parsed> parser) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, new NoKeyParser(parser), StalePolicy.UNSPECIFIED);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, Parser<Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy policy) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, new NoKeyParser(parser), memoryPolicy, policy);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy policy) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, parser, memoryPolicy, policy);
    }

    @Override
    @Nonnull
    public Observable<Parsed> get(@Nonnull Key key) {
        return this.internalStore.get(key);
    }

    @Override
    public Observable<Parsed> getRefreshing(@Nonnull Key key) {
        return this.internalStore.getRefreshing(key);
    }

    @Override
    @Nonnull
    public Observable<Parsed> fetch(@Nonnull Key key) {
        return this.internalStore.fetch(key);
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream() {
        return this.internalStore.stream();
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream(Key key) {
        return this.internalStore.stream(key);
    }

    @Override
    public void clearMemory() {
        this.internalStore.clearMemory();
    }

    @Override
    public void clearMemory(@Nonnull Key key) {
        this.internalStore.clearMemory(key);
    }

    @Override
    public void clear() {
        this.internalStore.clear();
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.internalStore.clear(key);
    }

    protected Observable<Parsed> memory(@Nonnull Key key) {
        return this.internalStore.memory(key);
    }

    @Nonnull
    protected Observable<Parsed> disk(@Nonnull Key key) {
        return this.internalStore.disk(key);
    }
}

