/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import java.util.concurrent.TimeUnit;

public class MemoryPolicy {
    private final long expireAfter;
    private final TimeUnit expireAfterTimeUnit;
    private final long maxSize;

    MemoryPolicy(long expireAfter, TimeUnit expireAfterTimeUnit, long maxSize) {
        this.expireAfter = expireAfter;
        this.expireAfterTimeUnit = expireAfterTimeUnit;
        this.maxSize = maxSize;
    }

    public static MemoryPolicyBuilder builder() {
        return new MemoryPolicyBuilder();
    }

    public long getExpireAfter() {
        return this.expireAfter;
    }

    public TimeUnit getExpireAfterTimeUnit() {
        return this.expireAfterTimeUnit;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public boolean isDefaultPolicy() {
        return this.expireAfter == -1L;
    }

    public static class MemoryPolicyBuilder {
        private long expireAfter = -1L;
        private TimeUnit expireAfterTimeUnit = TimeUnit.SECONDS;
        private long maxSize = 1L;

        public MemoryPolicyBuilder setExpireAfter(long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public MemoryPolicyBuilder setExpireAfterTimeUnit(TimeUnit expireAfterTimeUnit) {
            this.expireAfterTimeUnit = expireAfterTimeUnit;
            return this;
        }

        public MemoryPolicyBuilder setMemorySize(long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public MemoryPolicy build() {
            return new MemoryPolicy(this.expireAfter, this.expireAfterTimeUnit, this.maxSize);
        }
    }
}

