/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware;

import com.google.gson.Gson;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.middleware.GsonReaderParser;
import com.nytimes.android.external.store.middleware.GsonSourceParser;
import com.nytimes.android.external.store.middleware.GsonStringParser;
import java.io.Reader;
import java.lang.reflect.Type;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public final class GsonParserFactory {
    private GsonParserFactory() {
    }

    @NotNull
    public static <T> Parser<Reader, T> createReaderParser(@NotNull Type type) {
        return GsonParserFactory.createReaderParser(new Gson(), type);
    }

    @NotNull
    public static <T> Parser<Reader, T> createReaderParser(@NotNull Gson gson, @NotNull Type type) {
        return new GsonReaderParser(gson, type);
    }

    @NotNull
    public static <T> Parser<BufferedSource, T> createSourceParser(@NotNull Type type) {
        return GsonParserFactory.createSourceParser(new Gson(), type);
    }

    @NotNull
    public static <T> Parser<BufferedSource, T> createSourceParser(@NotNull Gson gson, @NotNull Type type) {
        return new GsonSourceParser(gson, type);
    }

    @NotNull
    public static <T> Parser<String, T> createStringParser(@NotNull Class<T> type) {
        return GsonParserFactory.createStringParser(new Gson(), type);
    }

    @NotNull
    public static <T> Parser<String, T> createStringParser(@NotNull Gson gson, @NotNull Type type) {
        return new GsonStringParser(gson, type);
    }
}

