/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.middleware.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.util.ParserException;
import io.reactivex.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.BufferedSource;

public class JacksonSourceParser<Parsed>
implements Parser<BufferedSource, Parsed> {
    private final ObjectMapper objectMapper;
    private final JavaType parsedType;

    public JacksonSourceParser(@Nonnull JsonFactory jsonFactory, @Nonnull Type type) {
        this.objectMapper = new ObjectMapper(jsonFactory);
        this.parsedType = this.objectMapper.constructType(type);
    }

    @Inject
    public JacksonSourceParser(@Nonnull ObjectMapper objectMapper, @Nonnull Type type) {
        this.objectMapper = objectMapper;
        this.parsedType = objectMapper.constructType(type);
    }

    public Parsed apply(@NonNull BufferedSource bufferedSource) throws ParserException {
        Object object;
        InputStream inputStream = bufferedSource.inputStream();
        try {
            object = this.objectMapper.readValue(inputStream, this.parsedType);
        }
        catch (IOException e) {
            throw new ParserException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (Parsed)object;
    }
}

