/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.middleware.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.util.ParserException;
import io.reactivex.annotations.NonNull;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class JacksonReaderParser<Parsed>
implements Parser<Reader, Parsed> {
    private final ObjectMapper objectMapper;
    private final JavaType parsedType;

    public JacksonReaderParser(@Nonnull JsonFactory jsonFactory, @Nonnull Type type) {
        this.objectMapper = new ObjectMapper(jsonFactory);
        this.parsedType = this.objectMapper.constructType(type);
    }

    @Inject
    public JacksonReaderParser(@Nonnull ObjectMapper objectMapper, @Nonnull Type type) {
        this.objectMapper = objectMapper;
        this.parsedType = objectMapper.constructType(type);
    }

    public Parsed apply(@NonNull Reader reader) throws ParserException {
        try {
            return (Parsed)this.objectMapper.readValue(reader, this.parsedType);
        }
        catch (IOException e) {
            throw new ParserException(e.getMessage(), (Throwable)e);
        }
    }
}

