/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.middleware.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.store3.base.Parser;
import com.nytimes.android.external.store3.middleware.jackson.JacksonReaderParser;
import com.nytimes.android.external.store3.middleware.jackson.JacksonSourceParser;
import com.nytimes.android.external.store3.middleware.jackson.JacksonStringParser;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import okio.BufferedSource;

public final class JacksonParserFactory {
    private JacksonParserFactory() {
    }

    @Nonnull
    public static <T> Parser<String, T> createStringParser(@Nonnull JsonFactory jsonFactory, @Nonnull Type type) {
        if (jsonFactory == null) {
            throw new NullPointerException("jsonFactory cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new JacksonStringParser(jsonFactory, type);
    }

    @Nonnull
    public static <T> Parser<String, T> createStringParser(@Nonnull ObjectMapper objectMapper, @Nonnull Type type) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new JacksonStringParser(objectMapper, type);
    }

    @Nonnull
    public static <T> Parser<String, T> createStringParser(@Nonnull Class<T> type) {
        return JacksonParserFactory.createStringParser(new ObjectMapper(), type);
    }

    @Nonnull
    public static <T> Parser<BufferedSource, T> createSourceParser(@Nonnull JsonFactory jsonFactory, @Nonnull Type type) {
        if (jsonFactory == null) {
            throw new NullPointerException("jsonFactory cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new JacksonSourceParser(jsonFactory, type);
    }

    @Nonnull
    public static <T> Parser<BufferedSource, T> createSourceParser(@Nonnull ObjectMapper objectMapper, @Nonnull Type type) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new JacksonSourceParser(objectMapper, type);
    }

    @Nonnull
    public static <T> Parser<BufferedSource, T> createSourceParser(@Nonnull Type type) {
        return JacksonParserFactory.createSourceParser(new ObjectMapper(), type);
    }

    @Nonnull
    public static <T> Parser<Reader, T> createReaderParser(@Nonnull JsonFactory jsonFactory, @Nonnull Type type) {
        if (jsonFactory == null) {
            throw new NullPointerException("objectMapper cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new JacksonReaderParser(jsonFactory, type);
    }

    @Nonnull
    public static <T> Parser<Reader, T> createReaderParser(@Nonnull ObjectMapper objectMapper, @Nonnull Type type) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        return new JacksonReaderParser(objectMapper, type);
    }

    @Nonnull
    public static <T> Parser<Reader, T> createReaderParser(@Nonnull Type type) {
        return JacksonParserFactory.createReaderParser(new ObjectMapper(), type);
    }
}

