/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.store.base.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import okio.BufferedSource;

public class JacksonSourceParser<Parsed>
implements Parser<BufferedSource, Parsed> {
    private final ObjectMapper objectMapper;
    private final JavaType parsedType;

    public JacksonSourceParser(@Nonnull JsonFactory jsonFactory, @Nonnull Type type) {
        this.objectMapper = new ObjectMapper(jsonFactory);
        this.parsedType = this.objectMapper.constructType(type);
    }

    @Inject
    public JacksonSourceParser(@Nonnull ObjectMapper objectMapper, @Nonnull Type type) {
        this.objectMapper = objectMapper;
        this.parsedType = objectMapper.constructType(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Parsed call(@Nonnull BufferedSource source) {
        Object object;
        InputStream inputStream = source.inputStream();
        try {
            object = this.objectMapper.readValue(inputStream, this.parsedType);
        }
        catch (IOException e) {
            Parsed Parsed = null;
            return Parsed;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (Parsed)object;
    }
}

