/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.store.base.Parser;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JacksonStringParser<Parsed>
implements Parser<String, Parsed> {
    private final ObjectMapper objectMapper;
    private final JavaType parsedType;

    public JacksonStringParser(@NotNull JsonFactory jsonFactory, @NotNull Type type) {
        this.objectMapper = new ObjectMapper(jsonFactory);
        this.parsedType = this.objectMapper.constructType(type);
    }

    @Inject
    public JacksonStringParser(@NotNull ObjectMapper objectMapper, @NotNull Type type) {
        this.objectMapper = objectMapper;
        this.parsedType = objectMapper.constructType(type);
    }

    @Nullable
    public Parsed call(@NotNull String source) {
        try {
            return (Parsed)this.objectMapper.readValue(source, this.parsedType);
        }
        catch (IOException e) {
            return null;
        }
    }
}

