/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.store.base.Parser;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class JacksonReaderParser<Parsed>
implements Parser<Reader, Parsed> {
    private final ObjectMapper objectMapper;
    private final JavaType parsedType;

    public JacksonReaderParser(@NotNull JsonFactory jsonFactory, @NotNull Type type) {
        this.objectMapper = new ObjectMapper(jsonFactory);
        this.parsedType = this.objectMapper.constructType(type);
    }

    @Inject
    public JacksonReaderParser(@NotNull ObjectMapper objectMapper, @NotNull Type type) {
        this.objectMapper = objectMapper;
        this.parsedType = objectMapper.constructType(type);
    }

    public Parsed call(@NotNull Reader reader) {
        try {
            return (Parsed)this.objectMapper.readValue(reader, this.parsedType);
        }
        catch (IOException e) {
            return null;
        }
    }
}

