/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.middleware.jackson.JacksonReaderParser;
import com.nytimes.android.external.store.middleware.jackson.JacksonSourceParser;
import com.nytimes.android.external.store.middleware.jackson.JacksonStringParser;
import java.io.Reader;
import java.lang.reflect.Type;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public final class JacksonParserFactory {
    private JacksonParserFactory() {
    }

    @NotNull
    public static <T> Parser<String, T> createStringParser(@NotNull JsonFactory jsonFactory, @NotNull Type type) {
        Preconditions.checkNotNull((Object)jsonFactory, (String)"jsonFactory cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new JacksonStringParser(jsonFactory, type);
    }

    @NotNull
    public static <T> Parser<String, T> createStringParser(@NotNull ObjectMapper objectMapper, @NotNull Type type) {
        Preconditions.checkNotNull((Object)objectMapper, (String)"objectMapper cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new JacksonStringParser(objectMapper, type);
    }

    @NotNull
    public static <T> Parser<String, T> createStringParser(@NotNull Class<T> type) {
        return JacksonParserFactory.createStringParser(new ObjectMapper(), type);
    }

    @NotNull
    public static <T> Parser<BufferedSource, T> createSourceParser(@NotNull JsonFactory jsonFactory, @NotNull Type type) {
        Preconditions.checkNotNull((Object)jsonFactory, (String)"jsonFactory cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new JacksonSourceParser(jsonFactory, type);
    }

    @NotNull
    public static <T> Parser<BufferedSource, T> createSourceParser(@NotNull ObjectMapper objectMapper, @NotNull Type type) {
        Preconditions.checkNotNull((Object)objectMapper, (String)"objectMapper cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new JacksonSourceParser(objectMapper, type);
    }

    @NotNull
    public static <T> Parser<BufferedSource, T> createSourceParser(@NotNull Type type) {
        return JacksonParserFactory.createSourceParser(new ObjectMapper(), type);
    }

    @NotNull
    public static <T> Parser<Reader, T> createReaderParser(@NotNull JsonFactory jsonFactory, @NotNull Type type) {
        Preconditions.checkNotNull((Object)jsonFactory, (String)"jsonFactory cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new JacksonReaderParser(jsonFactory, type);
    }

    @NotNull
    public static <T> Parser<Reader, T> createReaderParser(@NotNull ObjectMapper objectMapper, @NotNull Type type) {
        Preconditions.checkNotNull((Object)objectMapper, (String)"objectMapper cannot be null.");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null.");
        return new JacksonReaderParser(objectMapper, type);
    }

    @NotNull
    public static <T> Parser<Reader, T> createReaderParser(@NotNull Type type) {
        return JacksonParserFactory.createReaderParser(new ObjectMapper(), type);
    }
}

