/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs3;

import com.nytimes.android.external.fs3.BarCodeReadAllPathResolver;
import com.nytimes.android.external.fs3.FSAllEraser;
import com.nytimes.android.external.fs3.FSAllReader;
import com.nytimes.android.external.fs3.FSReader;
import com.nytimes.android.external.fs3.FSWriter;
import com.nytimes.android.external.fs3.filesystem.FileSystem;
import com.nytimes.android.external.store3.base.AllPersister;
import com.nytimes.android.external.store3.base.impl.BarCode;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.io.FileNotFoundException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.BufferedSource;

public class SourceAllPersister
implements AllPersister<BufferedSource, BarCode> {
    @Nonnull
    final FSAllReader sourceFileAllReader;
    @Nonnull
    final FSAllEraser sourceFileAllEraser;
    @Nonnull
    final FSReader<BarCode> sourceFileReader;
    @Nonnull
    final FSWriter<BarCode> sourceFileWriter;

    @Inject
    public SourceAllPersister(FileSystem fileSystem) {
        this.sourceFileAllReader = new FSAllReader(fileSystem);
        this.sourceFileAllEraser = new FSAllEraser(fileSystem);
        this.sourceFileReader = new FSReader<BarCode>(fileSystem, new BarCodeReadAllPathResolver());
        this.sourceFileWriter = new FSWriter<BarCode>(fileSystem, new BarCodeReadAllPathResolver());
    }

    @Nonnull
    public Observable<BufferedSource> readAll(@Nonnull String path) throws FileNotFoundException {
        return this.sourceFileAllReader.readAll(path);
    }

    @Nonnull
    public Observable<Boolean> deleteAll(@Nonnull String path) {
        return this.sourceFileAllEraser.deleteAll(path);
    }

    @Nonnull
    public Maybe<BufferedSource> read(@Nonnull BarCode barCode) {
        return this.sourceFileReader.read(barCode);
    }

    @Nonnull
    public Single<Boolean> write(@Nonnull BarCode barCode, @Nonnull BufferedSource data) {
        return this.sourceFileWriter.write(barCode, data);
    }

    public static SourceAllPersister create(FileSystem fileSystem) {
        return new SourceAllPersister(fileSystem);
    }
}

