/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs3;

import com.nytimes.android.external.fs3.FSReader$$Lambda$1;
import com.nytimes.android.external.fs3.PathResolver;
import com.nytimes.android.external.fs3.filesystem.FileSystem;
import com.nytimes.android.external.store3.base.DiskRead;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import okio.BufferedSource;

public class FSReader<T>
implements DiskRead<BufferedSource, T> {
    private static final String ERROR_MESSAGE = "resolvedKey does not resolve to a file";
    final FileSystem fileSystem;
    final PathResolver<T> pathResolver;

    public FSReader(FileSystem fileSystem, PathResolver<T> pathResolver) {
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    @Nonnull
    public Maybe<BufferedSource> read(@Nonnull T key) {
        return Maybe.create((MaybeOnSubscribe)FSReader$$Lambda$1.lambdaFactory$(this, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$read$0(@Nonnull FSReader this_, Object key, MaybeEmitter emitter) throws Exception {
        String resolvedKey = this_.pathResolver.resolve(key);
        boolean exists = this_.fileSystem.exists(resolvedKey);
        if (exists) {
            BufferedSource bufferedSource = null;
            try {
                bufferedSource = this_.fileSystem.read(resolvedKey);
                emitter.onSuccess((Object)bufferedSource);
                emitter.onComplete();
            }
            catch (FileNotFoundException e) {
                emitter.onError((Throwable)e);
            }
            finally {
                if (bufferedSource != null) {
                    try {
                        bufferedSource.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        } else {
            emitter.onError((Throwable)new FileNotFoundException(ERROR_MESSAGE + resolvedKey));
        }
    }
}

