/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.FSReader;
import com.nytimes.android.external.fs.FSWriter;
import com.nytimes.android.external.fs.PathResolver;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.Persister;
import javax.annotation.Nonnull;
import okio.BufferedSource;
import rx.Observable;

public final class FileSystemPersister<T>
implements Persister<BufferedSource, T> {
    private final FSReader<T> fileReader;
    private final FSWriter<T> fileWriter;

    private FileSystemPersister(FileSystem fileSystem, PathResolver<T> pathResolver) {
        this.fileReader = new FSReader<T>(fileSystem, pathResolver);
        this.fileWriter = new FSWriter<T>(fileSystem, pathResolver);
    }

    @Nonnull
    public static <T> Persister<BufferedSource, T> create(FileSystem fileSystem, PathResolver<T> pathResolver) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return new FileSystemPersister<T>(fileSystem, pathResolver);
    }

    @Nonnull
    public Observable<BufferedSource> read(@Nonnull T key) {
        return this.fileReader.read(key);
    }

    @Nonnull
    public Observable<Boolean> write(@Nonnull T key, @Nonnull BufferedSource data) {
        return this.fileWriter.write(key, data);
    }
}

