/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.BarCodeReadAllPathResolver;
import com.nytimes.android.external.fs.FSAllEraser;
import com.nytimes.android.external.fs.FSAllReader;
import com.nytimes.android.external.fs.FSReader;
import com.nytimes.android.external.fs.FSWriter;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.AllPersister;
import com.nytimes.android.external.store.base.impl.BarCode;
import java.io.FileNotFoundException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.BufferedSource;
import rx.Observable;

public class SourceAllPersister
implements AllPersister<BufferedSource, BarCode> {
    @Nonnull
    final FSAllReader sourceFileAllReader;
    @Nonnull
    final FSAllEraser sourceFileAllEraser;
    @Nonnull
    final FSReader<BarCode> sourceFileReader;
    @Nonnull
    final FSWriter<BarCode> sourceFileWriter;

    @Inject
    public SourceAllPersister(FileSystem fileSystem) {
        this.sourceFileAllReader = new FSAllReader(fileSystem);
        this.sourceFileAllEraser = new FSAllEraser(fileSystem);
        this.sourceFileReader = new FSReader<BarCode>(fileSystem, new BarCodeReadAllPathResolver());
        this.sourceFileWriter = new FSWriter<BarCode>(fileSystem, new BarCodeReadAllPathResolver());
    }

    @Nonnull
    public Observable<BufferedSource> readAll(@Nonnull String path) throws FileNotFoundException {
        return this.sourceFileAllReader.readAll(path);
    }

    @Nonnull
    public Observable<Boolean> deleteAll(@Nonnull String path) {
        return this.sourceFileAllEraser.deleteAll(path);
    }

    @Nonnull
    public Observable<BufferedSource> read(@Nonnull BarCode barCode) {
        return this.sourceFileReader.read(barCode);
    }

    @Nonnull
    public Observable<Boolean> write(@Nonnull BarCode barCode, @Nonnull BufferedSource data) {
        return this.sourceFileWriter.write(barCode, data);
    }
}

