/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.cache;

import com.nytimes.android.external.cache.Function;
import com.nytimes.android.external.cache.Futures;
import com.nytimes.android.external.cache.ListenableFuture;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.cache.Supplier;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class CacheLoader<K, V> {
    protected CacheLoader() {
    }

    @Nullable
    public abstract V load(K var1) throws Exception;

    @Nullable
    public ListenableFuture<V> reload(@Nonnull K key, @Nonnull V oldValue) throws Exception {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(oldValue);
        return Futures.immediateFuture(this.load(key));
    }

    @Nonnull
    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedLoadingOperationException();
    }

    @Nonnull
    public static <K, V> CacheLoader<K, V> from(@Nonnull Function<K, V> function) {
        return new FunctionToCacheLoader<K, V>(function);
    }

    @Nonnull
    public static <V> CacheLoader<Object, V> from(@Nonnull Supplier<V> supplier) {
        return new SupplierToCacheLoader<V>(supplier);
    }

    public static final class InvalidCacheLoadException
    extends RuntimeException {
        public InvalidCacheLoadException(String message) {
            super(message);
        }
    }

    public static final class UnsupportedLoadingOperationException
    extends UnsupportedOperationException {
        UnsupportedLoadingOperationException() {
        }
    }

    private static final class SupplierToCacheLoader<V>
    extends CacheLoader<Object, V>
    implements Serializable {
        private final Supplier<V> computingSupplier;
        private static final long serialVersionUID = 0L;

        public SupplierToCacheLoader(@Nonnull Supplier<V> computingSupplier) {
            this.computingSupplier = Preconditions.checkNotNull(computingSupplier);
        }

        @Override
        @Nonnull
        public V load(@Nonnull Object key) {
            Preconditions.checkNotNull(key);
            return this.computingSupplier.get();
        }
    }

    private static final class FunctionToCacheLoader<K, V>
    extends CacheLoader<K, V>
    implements Serializable {
        private final Function<K, V> computingFunction;
        private static final long serialVersionUID = 0L;

        public FunctionToCacheLoader(@Nonnull Function<K, V> computingFunction) {
            this.computingFunction = Preconditions.checkNotNull(computingFunction);
        }

        @Override
        @Nullable
        public V load(@Nonnull K key) {
            return this.computingFunction.apply(Preconditions.checkNotNull(key));
        }
    }
}

