/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.cache;

import com.nytimes.android.external.cache.Preconditions;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class MoreObjects {
    public static <T> T firstNonNull(T first, T second) {
        return first != null ? first : Preconditions.checkNotNull(second);
    }

    @NotNull
    public static ToStringHelper toStringHelper(@NotNull Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper {
        private final String className;
        @NotNull
        private ValueHolder holderHead;
        @NotNull
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(@NotNull String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(className);
        }

        @NotNull
        public ToStringHelper add(@NotNull String name, Object value) {
            return this.addHolder(name, value);
        }

        @NotNull
        public ToStringHelper add(@NotNull String name, int value) {
            return this.addHolder(name, String.valueOf(value));
        }

        @NotNull
        public ToStringHelper add(@NotNull String name, long value) {
            return this.addHolder(name, String.valueOf(value));
        }

        @NotNull
        public ToStringHelper addValue(Object value) {
            return this.addHolder(value);
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object value = valueHolder.value;
                if (!omitNullValuesSnapshot || value != null) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value != null && value.getClass().isArray()) {
                        Object[] objectArray = new Object[]{value};
                        String arrayString = Arrays.deepToString(objectArray);
                        builder.append(arrayString.substring(1, arrayString.length() - 1));
                    } else {
                        builder.append(value);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        @NotNull
        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        @NotNull
        private ToStringHelper addHolder(Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            return this;
        }

        @NotNull
        private ToStringHelper addHolder(@NotNull String name, Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private static final class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

