/*
 * Decompiled with CFR 0.152.
 */
package com.nyentek.promise;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Promise<T> {
    private static Handler Handler = new Handler(Looper.getMainLooper());
    private T model;
    private Status status = Status.PENDING;
    private Exception exception;
    private final Set<PromiseListener<T>> listeners = new HashSet<PromiseListener<T>>();

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getErrorMessage() {
        return this.exception != null ? (this.exception.getMessage() != null ? this.exception.getMessage() : "") : "";
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Promise<T> addListener(PromiseListener<T> listener) {
        this.listeners.add(listener);
        return this;
    }

    public Promise<T> removeListener(PromiseListener<T> listener) {
        this.listeners.remove(listener);
        return this;
    }

    public void notifyUpdate() {
        Handler.post(new Runnable(){

            @Override
            public void run() {
                for (PromiseListener listener : new ArrayList(Promise.this.listeners)) {
                    listener.onPromiseUpdate(Promise.this);
                }
            }
        });
    }

    public void _notifyUpdate() {
        for (PromiseListener<T> listener : new ArrayList<PromiseListener<T>>(this.listeners)) {
            listener.onPromiseUpdate(this);
        }
    }

    public static enum Status {
        PENDING,
        LOADING,
        SUCCESS,
        FAILURE;

    }

    public static interface PromiseListener<T> {
        public void onPromiseUpdate(Promise<T> var1);
    }
}

