/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.esxi.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.CategoryReference;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.CdRom;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.ClusterReference;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.Disk;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.HostReference;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.Nic;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.NutanixGuestTools;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.OwnershipInfo;
import com.nutanix.dp1.vmm.vmm.v4.esxi.config.PowerState;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vm
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Vm.class);
    @Min(value=1L)
    private @Min(value=1L) Long memorySizeBytes = null;
    @Min(value=1L)
    private @Min(value=1L) Long numCoresPerSocket = null;
    @Min(value=1L)
    private @Min(value=1L) Long numCpus = null;
    @Size(max=256)
    private @Size(max=256) String guestOsName = null;
    @Min(value=1L)
    private @Min(value=1L) Long virtualHardwareVersion = null;
    @Size(max=80)
    @JsonProperty(value="name")
    public @Size(max=80) String name = null;
    @JsonProperty(value="cluster")
    public ClusterReference cluster = null;
    @JsonProperty(value="host")
    public HostReference host = null;
    @JsonProperty(value="description")
    public String description = null;
    @Size(min=0, max=256)
    @JsonProperty(value="categories")
    public @Size(min=0, max=256) List<CategoryReference> categories = null;
    @JsonProperty(value="ownershipInfo")
    public OwnershipInfo ownershipInfo = null;
    @JsonProperty(value="nutanixGuestTools")
    public NutanixGuestTools nutanixGuestTools = null;
    @JsonProperty(value="powerState")
    public PowerState powerState = null;
    @Size(min=0, max=256)
    @JsonProperty(value="disks")
    public @Size(min=0, max=256) List<Disk> disks = null;
    @Size(min=0, max=256)
    @JsonProperty(value="cdRoms")
    public @Size(min=0, max=256) List<CdRom> cdRoms = null;
    @Size(min=0, max=32)
    @JsonProperty(value="nics")
    public @Size(min=0, max=32) List<Nic> nics = null;

    public Vm() {
    }

    public Vm(String tenantId, String extId, List<ApiLink> links, String name, ClusterReference cluster, HostReference host, String description, List<CategoryReference> categories, OwnershipInfo ownershipInfo, NutanixGuestTools nutanixGuestTools, PowerState powerState, Long memorySizeBytes, Long numCoresPerSocket, Long numCpus, String guestOsName, Long virtualHardwareVersion, List<Disk> disks, List<CdRom> cdRoms, List<Nic> nics) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setCluster(cluster);
        this.setHost(host);
        this.setDescription(description);
        this.setCategories(categories);
        this.setOwnershipInfo(ownershipInfo);
        this.setNutanixGuestTools(nutanixGuestTools);
        this.setPowerState(powerState);
        this.setMemorySizeBytes(memorySizeBytes);
        this.setNumCoresPerSocket(numCoresPerSocket);
        this.setNumCpus(numCpus);
        this.setGuestOsName(guestOsName);
        this.setVirtualHardwareVersion(virtualHardwareVersion);
        this.setDisks(disks);
        this.setCdRoms(cdRoms);
        this.setNics(nics);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.esxi.config.Vm";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setMemorySizeBytes(Long memorySizeBytes) {
        if (this.memorySizeBytes == null) {
            this.memorySizeBytes = memorySizeBytes;
        } else {
            log.warn("Read-only property memorySizeBytes already contains a non-null value and cannot be set again");
        }
    }

    public void setNumCoresPerSocket(Long numCoresPerSocket) {
        if (this.numCoresPerSocket == null) {
            this.numCoresPerSocket = numCoresPerSocket;
        } else {
            log.warn("Read-only property numCoresPerSocket already contains a non-null value and cannot be set again");
        }
    }

    public void setNumCpus(Long numCpus) {
        if (this.numCpus == null) {
            this.numCpus = numCpus;
        } else {
            log.warn("Read-only property numCpus already contains a non-null value and cannot be set again");
        }
    }

    public void setGuestOsName(String guestOsName) {
        if (this.guestOsName == null) {
            this.guestOsName = guestOsName;
        } else {
            log.warn("Read-only property guestOsName already contains a non-null value and cannot be set again");
        }
    }

    public void setVirtualHardwareVersion(Long virtualHardwareVersion) {
        if (this.virtualHardwareVersion == null) {
            this.virtualHardwareVersion = virtualHardwareVersion;
        } else {
            log.warn("Read-only property virtualHardwareVersion already contains a non-null value and cannot be set again");
        }
    }

    public static VmBuilder VmBuilder() {
        return new VmBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vm)) {
            return false;
        }
        Vm other = (Vm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$memorySizeBytes = this.getMemorySizeBytes();
        Long other$memorySizeBytes = other.getMemorySizeBytes();
        if (this$memorySizeBytes == null ? other$memorySizeBytes != null : !((Object)this$memorySizeBytes).equals(other$memorySizeBytes)) {
            return false;
        }
        Long this$numCoresPerSocket = this.getNumCoresPerSocket();
        Long other$numCoresPerSocket = other.getNumCoresPerSocket();
        if (this$numCoresPerSocket == null ? other$numCoresPerSocket != null : !((Object)this$numCoresPerSocket).equals(other$numCoresPerSocket)) {
            return false;
        }
        Long this$numCpus = this.getNumCpus();
        Long other$numCpus = other.getNumCpus();
        if (this$numCpus == null ? other$numCpus != null : !((Object)this$numCpus).equals(other$numCpus)) {
            return false;
        }
        String this$guestOsName = this.getGuestOsName();
        String other$guestOsName = other.getGuestOsName();
        if (this$guestOsName == null ? other$guestOsName != null : !this$guestOsName.equals(other$guestOsName)) {
            return false;
        }
        Long this$virtualHardwareVersion = this.getVirtualHardwareVersion();
        Long other$virtualHardwareVersion = other.getVirtualHardwareVersion();
        if (this$virtualHardwareVersion == null ? other$virtualHardwareVersion != null : !((Object)this$virtualHardwareVersion).equals(other$virtualHardwareVersion)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ClusterReference this$cluster = this.getCluster();
        ClusterReference other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
            return false;
        }
        HostReference this$host = this.getHost();
        HostReference other$host = other.getHost();
        if (this$host == null ? other$host != null : !((Object)this$host).equals(other$host)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<CategoryReference> this$categories = this.getCategories();
        List<CategoryReference> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        OwnershipInfo this$ownershipInfo = this.getOwnershipInfo();
        OwnershipInfo other$ownershipInfo = other.getOwnershipInfo();
        if (this$ownershipInfo == null ? other$ownershipInfo != null : !((Object)this$ownershipInfo).equals(other$ownershipInfo)) {
            return false;
        }
        NutanixGuestTools this$nutanixGuestTools = this.getNutanixGuestTools();
        NutanixGuestTools other$nutanixGuestTools = other.getNutanixGuestTools();
        if (this$nutanixGuestTools == null ? other$nutanixGuestTools != null : !((Object)this$nutanixGuestTools).equals(other$nutanixGuestTools)) {
            return false;
        }
        PowerState this$powerState = this.getPowerState();
        PowerState other$powerState = other.getPowerState();
        if (this$powerState == null ? other$powerState != null : !((Object)((Object)this$powerState)).equals((Object)other$powerState)) {
            return false;
        }
        List<Disk> this$disks = this.getDisks();
        List<Disk> other$disks = other.getDisks();
        if (this$disks == null ? other$disks != null : !((Object)this$disks).equals(other$disks)) {
            return false;
        }
        List<CdRom> this$cdRoms = this.getCdRoms();
        List<CdRom> other$cdRoms = other.getCdRoms();
        if (this$cdRoms == null ? other$cdRoms != null : !((Object)this$cdRoms).equals(other$cdRoms)) {
            return false;
        }
        List<Nic> this$nics = this.getNics();
        List<Nic> other$nics = other.getNics();
        return !(this$nics == null ? other$nics != null : !((Object)this$nics).equals(other$nics));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Vm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $memorySizeBytes = this.getMemorySizeBytes();
        result = result * 59 + ($memorySizeBytes == null ? 43 : ((Object)$memorySizeBytes).hashCode());
        Long $numCoresPerSocket = this.getNumCoresPerSocket();
        result = result * 59 + ($numCoresPerSocket == null ? 43 : ((Object)$numCoresPerSocket).hashCode());
        Long $numCpus = this.getNumCpus();
        result = result * 59 + ($numCpus == null ? 43 : ((Object)$numCpus).hashCode());
        String $guestOsName = this.getGuestOsName();
        result = result * 59 + ($guestOsName == null ? 43 : $guestOsName.hashCode());
        Long $virtualHardwareVersion = this.getVirtualHardwareVersion();
        result = result * 59 + ($virtualHardwareVersion == null ? 43 : ((Object)$virtualHardwareVersion).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ClusterReference $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        HostReference $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : ((Object)$host).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<CategoryReference> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        OwnershipInfo $ownershipInfo = this.getOwnershipInfo();
        result = result * 59 + ($ownershipInfo == null ? 43 : ((Object)$ownershipInfo).hashCode());
        NutanixGuestTools $nutanixGuestTools = this.getNutanixGuestTools();
        result = result * 59 + ($nutanixGuestTools == null ? 43 : ((Object)$nutanixGuestTools).hashCode());
        PowerState $powerState = this.getPowerState();
        result = result * 59 + ($powerState == null ? 43 : ((Object)((Object)$powerState)).hashCode());
        List<Disk> $disks = this.getDisks();
        result = result * 59 + ($disks == null ? 43 : ((Object)$disks).hashCode());
        List<CdRom> $cdRoms = this.getCdRoms();
        result = result * 59 + ($cdRoms == null ? 43 : ((Object)$cdRoms).hashCode());
        List<Nic> $nics = this.getNics();
        result = result * 59 + ($nics == null ? 43 : ((Object)$nics).hashCode());
        return result;
    }

    public Long getMemorySizeBytes() {
        return this.memorySizeBytes;
    }

    public Long getNumCoresPerSocket() {
        return this.numCoresPerSocket;
    }

    public Long getNumCpus() {
        return this.numCpus;
    }

    public String getGuestOsName() {
        return this.guestOsName;
    }

    public Long getVirtualHardwareVersion() {
        return this.virtualHardwareVersion;
    }

    public String getName() {
        return this.name;
    }

    public ClusterReference getCluster() {
        return this.cluster;
    }

    public HostReference getHost() {
        return this.host;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CategoryReference> getCategories() {
        return this.categories;
    }

    public OwnershipInfo getOwnershipInfo() {
        return this.ownershipInfo;
    }

    public NutanixGuestTools getNutanixGuestTools() {
        return this.nutanixGuestTools;
    }

    public PowerState getPowerState() {
        return this.powerState;
    }

    public List<Disk> getDisks() {
        return this.disks;
    }

    public List<CdRom> getCdRoms() {
        return this.cdRoms;
    }

    public List<Nic> getNics() {
        return this.nics;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="cluster")
    public void setCluster(ClusterReference cluster) {
        this.cluster = cluster;
    }

    @JsonProperty(value="host")
    public void setHost(HostReference host) {
        this.host = host;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="categories")
    public void setCategories(List<CategoryReference> categories) {
        this.categories = categories;
    }

    @JsonProperty(value="ownershipInfo")
    public void setOwnershipInfo(OwnershipInfo ownershipInfo) {
        this.ownershipInfo = ownershipInfo;
    }

    @JsonProperty(value="nutanixGuestTools")
    public void setNutanixGuestTools(NutanixGuestTools nutanixGuestTools) {
        this.nutanixGuestTools = nutanixGuestTools;
    }

    @JsonProperty(value="powerState")
    public void setPowerState(PowerState powerState) {
        this.powerState = powerState;
    }

    @JsonProperty(value="disks")
    public void setDisks(List<Disk> disks) {
        this.disks = disks;
    }

    @JsonProperty(value="cdRoms")
    public void setCdRoms(List<CdRom> cdRoms) {
        this.cdRoms = cdRoms;
    }

    @JsonProperty(value="nics")
    public void setNics(List<Nic> nics) {
        this.nics = nics;
    }

    @Override
    public String toString() {
        return "Vm(memorySizeBytes=" + this.getMemorySizeBytes() + ", numCoresPerSocket=" + this.getNumCoresPerSocket() + ", numCpus=" + this.getNumCpus() + ", guestOsName=" + this.getGuestOsName() + ", virtualHardwareVersion=" + this.getVirtualHardwareVersion() + ", name=" + this.getName() + ", cluster=" + this.getCluster() + ", host=" + this.getHost() + ", description=" + this.getDescription() + ", categories=" + this.getCategories() + ", ownershipInfo=" + this.getOwnershipInfo() + ", nutanixGuestTools=" + this.getNutanixGuestTools() + ", powerState=" + (Object)((Object)this.getPowerState()) + ", disks=" + this.getDisks() + ", cdRoms=" + this.getCdRoms() + ", nics=" + this.getNics() + ")";
    }

    public static class VmBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private ClusterReference cluster;
        private HostReference host;
        private String description;
        private List<CategoryReference> categories;
        private OwnershipInfo ownershipInfo;
        private NutanixGuestTools nutanixGuestTools;
        private PowerState powerState;
        private Long memorySizeBytes;
        private Long numCoresPerSocket;
        private Long numCpus;
        private String guestOsName;
        private Long virtualHardwareVersion;
        private List<Disk> disks;
        private List<CdRom> cdRoms;
        private List<Nic> nics;

        VmBuilder() {
        }

        public VmBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VmBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VmBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VmBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VmBuilder cluster(ClusterReference cluster) {
            this.cluster = cluster;
            return this;
        }

        public VmBuilder host(HostReference host) {
            this.host = host;
            return this;
        }

        public VmBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VmBuilder categories(List<CategoryReference> categories) {
            this.categories = categories;
            return this;
        }

        public VmBuilder ownershipInfo(OwnershipInfo ownershipInfo) {
            this.ownershipInfo = ownershipInfo;
            return this;
        }

        public VmBuilder nutanixGuestTools(NutanixGuestTools nutanixGuestTools) {
            this.nutanixGuestTools = nutanixGuestTools;
            return this;
        }

        public VmBuilder powerState(PowerState powerState) {
            this.powerState = powerState;
            return this;
        }

        public VmBuilder memorySizeBytes(Long memorySizeBytes) {
            this.memorySizeBytes = memorySizeBytes;
            return this;
        }

        public VmBuilder numCoresPerSocket(Long numCoresPerSocket) {
            this.numCoresPerSocket = numCoresPerSocket;
            return this;
        }

        public VmBuilder numCpus(Long numCpus) {
            this.numCpus = numCpus;
            return this;
        }

        public VmBuilder guestOsName(String guestOsName) {
            this.guestOsName = guestOsName;
            return this;
        }

        public VmBuilder virtualHardwareVersion(Long virtualHardwareVersion) {
            this.virtualHardwareVersion = virtualHardwareVersion;
            return this;
        }

        public VmBuilder disks(List<Disk> disks) {
            this.disks = disks;
            return this;
        }

        public VmBuilder cdRoms(List<CdRom> cdRoms) {
            this.cdRoms = cdRoms;
            return this;
        }

        public VmBuilder nics(List<Nic> nics) {
            this.nics = nics;
            return this;
        }

        public Vm build() {
            return new Vm(this.tenantId, this.extId, this.links, this.name, this.cluster, this.host, this.description, this.categories, this.ownershipInfo, this.nutanixGuestTools, this.powerState, this.memorySizeBytes, this.numCoresPerSocket, this.numCpus, this.guestOsName, this.virtualHardwareVersion, this.disks, this.cdRoms, this.nics);
        }

        public String toString() {
            return "Vm.VmBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", cluster=" + this.cluster + ", host=" + this.host + ", description=" + this.description + ", categories=" + this.categories + ", ownershipInfo=" + this.ownershipInfo + ", nutanixGuestTools=" + this.nutanixGuestTools + ", powerState=" + (Object)((Object)this.powerState) + ", memorySizeBytes=" + this.memorySizeBytes + ", numCoresPerSocket=" + this.numCoresPerSocket + ", numCpus=" + this.numCpus + ", guestOsName=" + this.guestOsName + ", virtualHardwareVersion=" + this.virtualHardwareVersion + ", disks=" + this.disks + ", cdRoms=" + this.cdRoms + ", nics=" + this.nics + ")";
        }
    }
}

