/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.content;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.vmm.v4.content.VmConfigOverride;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateDeployment
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(TemplateDeployment.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="versionId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String versionId = null;
    @Max(value=250L)
    @Min(value=1L)
    @JsonProperty(value="numberOfVms")
    public @Max(value=250L) @Min(value=1L) Integer numberOfVms = 1;
    @JsonProperty(value="overrideVmConfigMap")
    public Map<String, VmConfigOverride> overrideVmConfigMap = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterReference")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterReference = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public TemplateDeployment() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public TemplateDeployment(String versionId, Integer numberOfVms, Map<String, VmConfigOverride> overrideVmConfigMap, String clusterReference) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setVersionId(versionId);
        this.setNumberOfVms(numberOfVms);
        this.setOverrideVmConfigMap(overrideVmConfigMap);
        this.setClusterReference(clusterReference);
    }

    protected String initialize$objectType() {
        return "vmm.v4.content.TemplateDeployment";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static TemplateDeploymentBuilder TemplateDeploymentBuilder() {
        return new TemplateDeploymentBuilder();
    }

    public String getVersionId() {
        return this.versionId;
    }

    public Integer getNumberOfVms() {
        return this.numberOfVms;
    }

    public Map<String, VmConfigOverride> getOverrideVmConfigMap() {
        return this.overrideVmConfigMap;
    }

    public String getClusterReference() {
        return this.clusterReference;
    }

    @JsonProperty(value="versionId")
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @JsonProperty(value="numberOfVms")
    public void setNumberOfVms(Integer numberOfVms) {
        this.numberOfVms = numberOfVms;
    }

    @JsonProperty(value="overrideVmConfigMap")
    public void setOverrideVmConfigMap(Map<String, VmConfigOverride> overrideVmConfigMap) {
        this.overrideVmConfigMap = overrideVmConfigMap;
    }

    @JsonProperty(value="clusterReference")
    public void setClusterReference(String clusterReference) {
        this.clusterReference = clusterReference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateDeployment)) {
            return false;
        }
        TemplateDeployment other = (TemplateDeployment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$versionId = this.getVersionId();
        String other$versionId = other.getVersionId();
        if (this$versionId == null ? other$versionId != null : !this$versionId.equals(other$versionId)) {
            return false;
        }
        Integer this$numberOfVms = this.getNumberOfVms();
        Integer other$numberOfVms = other.getNumberOfVms();
        if (this$numberOfVms == null ? other$numberOfVms != null : !((Object)this$numberOfVms).equals(other$numberOfVms)) {
            return false;
        }
        Map<String, VmConfigOverride> this$overrideVmConfigMap = this.getOverrideVmConfigMap();
        Map<String, VmConfigOverride> other$overrideVmConfigMap = other.getOverrideVmConfigMap();
        if (this$overrideVmConfigMap == null ? other$overrideVmConfigMap != null : !((Object)this$overrideVmConfigMap).equals(other$overrideVmConfigMap)) {
            return false;
        }
        String this$clusterReference = this.getClusterReference();
        String other$clusterReference = other.getClusterReference();
        return !(this$clusterReference == null ? other$clusterReference != null : !this$clusterReference.equals(other$clusterReference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateDeployment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $versionId = this.getVersionId();
        result = result * 59 + ($versionId == null ? 43 : $versionId.hashCode());
        Integer $numberOfVms = this.getNumberOfVms();
        result = result * 59 + ($numberOfVms == null ? 43 : ((Object)$numberOfVms).hashCode());
        Map<String, VmConfigOverride> $overrideVmConfigMap = this.getOverrideVmConfigMap();
        result = result * 59 + ($overrideVmConfigMap == null ? 43 : ((Object)$overrideVmConfigMap).hashCode());
        String $clusterReference = this.getClusterReference();
        result = result * 59 + ($clusterReference == null ? 43 : $clusterReference.hashCode());
        return result;
    }

    public String toString() {
        return "TemplateDeployment(versionId=" + this.getVersionId() + ", numberOfVms=" + this.getNumberOfVms() + ", overrideVmConfigMap=" + this.getOverrideVmConfigMap() + ", clusterReference=" + this.getClusterReference() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class TemplateDeploymentBuilder {
        private String versionId;
        private Integer numberOfVms;
        private Map<String, VmConfigOverride> overrideVmConfigMap;
        private String clusterReference;

        TemplateDeploymentBuilder() {
        }

        public TemplateDeploymentBuilder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public TemplateDeploymentBuilder numberOfVms(Integer numberOfVms) {
            this.numberOfVms = numberOfVms;
            return this;
        }

        public TemplateDeploymentBuilder overrideVmConfigMap(Map<String, VmConfigOverride> overrideVmConfigMap) {
            this.overrideVmConfigMap = overrideVmConfigMap;
            return this;
        }

        public TemplateDeploymentBuilder clusterReference(String clusterReference) {
            this.clusterReference = clusterReference;
            return this;
        }

        public TemplateDeployment build() {
            return new TemplateDeployment(this.versionId, this.numberOfVms, this.overrideVmConfigMap, this.clusterReference);
        }

        public String toString() {
            return "TemplateDeployment.TemplateDeploymentBuilder(versionId=" + this.versionId + ", numberOfVms=" + this.numberOfVms + ", overrideVmConfigMap=" + this.overrideVmConfigMap + ", clusterReference=" + this.clusterReference + ")";
        }
    }
}

