/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.content;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.vmm.annotations.VmmJsonDeserializer;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.deserializers.VmmOneOfDeserializer;
import com.nutanix.dp1.vmm.serializers.VmmOneOfSerializer;
import com.nutanix.dp1.vmm.vmm.v4.content.ImagePlacementStatus;
import com.nutanix.dp1.vmm.vmm.v4.content.ImageSha1Checksum;
import com.nutanix.dp1.vmm.vmm.v4.content.ImageSha256Checksum;
import com.nutanix.dp1.vmm.vmm.v4.content.ImageType;
import com.nutanix.dp1.vmm.vmm.v4.content.ObjectsLiteSource;
import com.nutanix.dp1.vmm.vmm.v4.content.UrlSource;
import com.nutanix.dp1.vmm.vmm.v4.content.VmDiskSource;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Image
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Image.class);
    private Long sizeBytes = null;
    private OffsetDateTime createTime = null;
    private OffsetDateTime lastUpdateTime = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String ownerExtId = null;
    @Size(min=0, max=100)
    private @Size(min=0, max=100) List<ImagePlacementStatus> placementPolicyStatus = null;
    @Size(min=1, max=256)
    @JsonProperty(value="name")
    public @Size(min=1, max=256) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="type")
    public ImageType type = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $checksumItemDiscriminator = null;
    private OneOfChecksumWrapper checksum = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $sourceItemDiscriminator = null;
    private OneOfSourceWrapper source = null;
    @Size(min=0, max=1250)
    @JsonProperty(value="categoryExtIds")
    public @Size(min=0, max=1250) List<String> categoryExtIds = null;
    @Size(min=0, max=200)
    @JsonProperty(value="clusterLocationExtIds")
    public @Size(min=0, max=200) List<String> clusterLocationExtIds = null;

    public Image() {
    }

    public Image(String tenantId, String extId, List<ApiLink> links, String name, String description, ImageType type, Object checksum, Long sizeBytes, Object source, List<String> categoryExtIds, List<String> clusterLocationExtIds, OffsetDateTime createTime, OffsetDateTime lastUpdateTime, String ownerExtId, List<ImagePlacementStatus> placementPolicyStatus) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setType(type);
        this.setChecksumInWrapper(checksum);
        this.setSizeBytes(sizeBytes);
        this.setSourceInWrapper(source);
        this.setCategoryExtIds(categoryExtIds);
        this.setClusterLocationExtIds(clusterLocationExtIds);
        this.setCreateTime(createTime);
        this.setLastUpdateTime(lastUpdateTime);
        this.setOwnerExtId(ownerExtId);
        this.setPlacementPolicyStatus(placementPolicyStatus);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.content.Image";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setSizeBytes(Long sizeBytes) {
        if (this.sizeBytes == null) {
            this.sizeBytes = sizeBytes;
        } else {
            log.warn("Read-only property sizeBytes already contains a non-null value and cannot be set again");
        }
    }

    public void setCreateTime(OffsetDateTime createTime) {
        if (this.createTime == null) {
            this.createTime = createTime;
        } else {
            log.warn("Read-only property createTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        if (this.lastUpdateTime == null) {
            this.lastUpdateTime = lastUpdateTime;
        } else {
            log.warn("Read-only property lastUpdateTime already contains a non-null value and cannot be set again");
        }
    }

    public void setOwnerExtId(String ownerExtId) {
        if (this.ownerExtId == null) {
            this.ownerExtId = ownerExtId;
        } else {
            log.warn("Read-only property ownerExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setPlacementPolicyStatus(List<ImagePlacementStatus> placementPolicyStatus) {
        if (this.placementPolicyStatus == null) {
            this.placementPolicyStatus = placementPolicyStatus;
        } else {
            log.warn("Read-only property placementPolicyStatus already contains a non-null value and cannot be set again");
        }
    }

    public String get$checksumItemDiscriminator() {
        if (this.checksum != null && this.$checksumItemDiscriminator == null) {
            this.$checksumItemDiscriminator = this.checksum.getDiscriminator();
        }
        return this.$checksumItemDiscriminator;
    }

    @JsonIgnore
    public void setChecksumInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.checksum == null) {
            this.checksum = new OneOfChecksumWrapper();
        }
        this.checksum.setValue(value);
        this.$checksumItemDiscriminator = this.checksum.getDiscriminator();
    }

    @JsonSerialize(using=VmmOneOfSerializer.class)
    public Object getChecksum() {
        if (this.checksum == null) {
            log.debug("OneOf property checksum was never set. Returning null...");
            return null;
        }
        return this.checksum.getValue();
    }

    public String get$sourceItemDiscriminator() {
        if (this.source != null && this.$sourceItemDiscriminator == null) {
            this.$sourceItemDiscriminator = this.source.getDiscriminator();
        }
        return this.$sourceItemDiscriminator;
    }

    @JsonIgnore
    public void setSourceInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.source == null) {
            this.source = new OneOfSourceWrapper();
        }
        this.source.setValue(value);
        this.$sourceItemDiscriminator = this.source.getDiscriminator();
    }

    @JsonSerialize(using=VmmOneOfSerializer.class)
    public Object getSource() {
        if (this.source == null) {
            log.debug("OneOf property source was never set. Returning null...");
            return null;
        }
        return this.source.getValue();
    }

    public static ImageBuilder ImageBuilder() {
        return new ImageBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdateTime = this.getLastUpdateTime();
        OffsetDateTime other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$ownerExtId = this.getOwnerExtId();
        String other$ownerExtId = other.getOwnerExtId();
        if (this$ownerExtId == null ? other$ownerExtId != null : !this$ownerExtId.equals(other$ownerExtId)) {
            return false;
        }
        List<ImagePlacementStatus> this$placementPolicyStatus = this.getPlacementPolicyStatus();
        List<ImagePlacementStatus> other$placementPolicyStatus = other.getPlacementPolicyStatus();
        if (this$placementPolicyStatus == null ? other$placementPolicyStatus != null : !((Object)this$placementPolicyStatus).equals(other$placementPolicyStatus)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ImageType this$type = this.getType();
        ImageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Object this$checksum = this.getChecksum();
        Object other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
            return false;
        }
        Object this$source = this.getSource();
        Object other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<String> this$categoryExtIds = this.getCategoryExtIds();
        List<String> other$categoryExtIds = other.getCategoryExtIds();
        if (this$categoryExtIds == null ? other$categoryExtIds != null : !((Object)this$categoryExtIds).equals(other$categoryExtIds)) {
            return false;
        }
        List<String> this$clusterLocationExtIds = this.getClusterLocationExtIds();
        List<String> other$clusterLocationExtIds = other.getClusterLocationExtIds();
        return !(this$clusterLocationExtIds == null ? other$clusterLocationExtIds != null : !((Object)this$clusterLocationExtIds).equals(other$clusterLocationExtIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $ownerExtId = this.getOwnerExtId();
        result = result * 59 + ($ownerExtId == null ? 43 : $ownerExtId.hashCode());
        List<ImagePlacementStatus> $placementPolicyStatus = this.getPlacementPolicyStatus();
        result = result * 59 + ($placementPolicyStatus == null ? 43 : ((Object)$placementPolicyStatus).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ImageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Object $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        Object $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<String> $categoryExtIds = this.getCategoryExtIds();
        result = result * 59 + ($categoryExtIds == null ? 43 : ((Object)$categoryExtIds).hashCode());
        List<String> $clusterLocationExtIds = this.getClusterLocationExtIds();
        result = result * 59 + ($clusterLocationExtIds == null ? 43 : ((Object)$clusterLocationExtIds).hashCode());
        return result;
    }

    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getOwnerExtId() {
        return this.ownerExtId;
    }

    public List<ImagePlacementStatus> getPlacementPolicyStatus() {
        return this.placementPolicyStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageType getType() {
        return this.type;
    }

    public List<String> getCategoryExtIds() {
        return this.categoryExtIds;
    }

    public List<String> getClusterLocationExtIds() {
        return this.clusterLocationExtIds;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="type")
    public void setType(ImageType type) {
        this.type = type;
    }

    public void setChecksum(OneOfChecksumWrapper checksum) {
        this.checksum = checksum;
    }

    public void setSource(OneOfSourceWrapper source) {
        this.source = source;
    }

    @JsonProperty(value="categoryExtIds")
    public void setCategoryExtIds(List<String> categoryExtIds) {
        this.categoryExtIds = categoryExtIds;
    }

    @JsonProperty(value="clusterLocationExtIds")
    public void setClusterLocationExtIds(List<String> clusterLocationExtIds) {
        this.clusterLocationExtIds = clusterLocationExtIds;
    }

    @Override
    public String toString() {
        return "Image(sizeBytes=" + this.getSizeBytes() + ", createTime=" + this.getCreateTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", ownerExtId=" + this.getOwnerExtId() + ", placementPolicyStatus=" + this.getPlacementPolicyStatus() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + (Object)((Object)this.getType()) + ", checksum=" + this.getChecksum() + ", source=" + this.getSource() + ", categoryExtIds=" + this.getCategoryExtIds() + ", clusterLocationExtIds=" + this.getClusterLocationExtIds() + ")";
    }

    public static class ImageBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private ImageType type;
        private Object checksum;
        private Long sizeBytes;
        private Object source;
        private List<String> categoryExtIds;
        private List<String> clusterLocationExtIds;
        private OffsetDateTime createTime;
        private OffsetDateTime lastUpdateTime;
        private String ownerExtId;
        private List<ImagePlacementStatus> placementPolicyStatus;

        ImageBuilder() {
        }

        public ImageBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ImageBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ImageBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ImageBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ImageBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ImageBuilder type(ImageType type) {
            this.type = type;
            return this;
        }

        public ImageBuilder checksum(Object checksum) {
            this.checksum = checksum;
            return this;
        }

        public ImageBuilder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public ImageBuilder source(Object source) {
            this.source = source;
            return this;
        }

        public ImageBuilder categoryExtIds(List<String> categoryExtIds) {
            this.categoryExtIds = categoryExtIds;
            return this;
        }

        public ImageBuilder clusterLocationExtIds(List<String> clusterLocationExtIds) {
            this.clusterLocationExtIds = clusterLocationExtIds;
            return this;
        }

        public ImageBuilder createTime(OffsetDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public ImageBuilder lastUpdateTime(OffsetDateTime lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public ImageBuilder ownerExtId(String ownerExtId) {
            this.ownerExtId = ownerExtId;
            return this;
        }

        public ImageBuilder placementPolicyStatus(List<ImagePlacementStatus> placementPolicyStatus) {
            this.placementPolicyStatus = placementPolicyStatus;
            return this;
        }

        public Image build() {
            return new Image(this.tenantId, this.extId, this.links, this.name, this.description, this.type, this.checksum, this.sizeBytes, this.source, this.categoryExtIds, this.clusterLocationExtIds, this.createTime, this.lastUpdateTime, this.ownerExtId, this.placementPolicyStatus);
        }

        public String toString() {
            return "Image.ImageBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", type=" + (Object)((Object)this.type) + ", checksum=" + this.checksum + ", sizeBytes=" + this.sizeBytes + ", source=" + this.source + ", categoryExtIds=" + this.categoryExtIds + ", clusterLocationExtIds=" + this.clusterLocationExtIds + ", createTime=" + this.createTime + ", lastUpdateTime=" + this.lastUpdateTime + ", ownerExtId=" + this.ownerExtId + ", placementPolicyStatus=" + this.placementPolicyStatus + ")";
        }
    }

    @JsonDeserialize(using=OneOfSourceWrapperJsonDeserializer.class)
    public static class OneOfSourceWrapper {
        @JsonIgnore
        private UrlSource oneOfType0;
        @JsonIgnore
        private VmDiskSource oneOfType1;
        @JsonIgnore
        private ObjectsLiteSource oneOfType2;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfSourceWrapper() {
        }

        public OneOfSourceWrapper(UrlSource data) {
            this.oneOfType0 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfSourceWrapper(VmDiskSource data) {
            this.oneOfType1 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfSourceWrapper(ObjectsLiteSource data) {
            this.oneOfType2 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType0 != null && this.oneOfType0.get$objectType().equals(this.discriminator)) {
                return this.oneOfType0;
            }
            if (this.oneOfType1 != null && this.oneOfType1.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1;
            }
            if (this.oneOfType2 != null && this.oneOfType2.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof UrlSource) {
                this.oneOfType0 = (UrlSource)value;
                this.discriminator = this.oneOfType0.get$objectType();
                this.$objectType = this.oneOfType0.get$objectType();
                return;
            }
            if (value instanceof VmDiskSource) {
                this.oneOfType1 = (VmDiskSource)value;
                this.discriminator = this.oneOfType1.get$objectType();
                this.$objectType = this.oneOfType1.get$objectType();
                return;
            }
            if (value instanceof ObjectsLiteSource) {
                this.oneOfType2 = (ObjectsLiteSource)value;
                this.discriminator = this.oneOfType2.get$objectType();
                this.$objectType = this.oneOfType2.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfSourceWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfSourceWrapper)) {
                return false;
            }
            OneOfSourceWrapper other = (OneOfSourceWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UrlSource this$oneOfType0 = this.oneOfType0;
            UrlSource other$oneOfType0 = other.oneOfType0;
            if (this$oneOfType0 == null ? other$oneOfType0 != null : !((Object)this$oneOfType0).equals(other$oneOfType0)) {
                return false;
            }
            VmDiskSource this$oneOfType1 = this.oneOfType1;
            VmDiskSource other$oneOfType1 = other.oneOfType1;
            if (this$oneOfType1 == null ? other$oneOfType1 != null : !((Object)this$oneOfType1).equals(other$oneOfType1)) {
                return false;
            }
            ObjectsLiteSource this$oneOfType2 = this.oneOfType2;
            ObjectsLiteSource other$oneOfType2 = other.oneOfType2;
            if (this$oneOfType2 == null ? other$oneOfType2 != null : !((Object)this$oneOfType2).equals(other$oneOfType2)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfSourceWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UrlSource $oneOfType0 = this.oneOfType0;
            result = result * 59 + ($oneOfType0 == null ? 43 : ((Object)$oneOfType0).hashCode());
            VmDiskSource $oneOfType1 = this.oneOfType1;
            result = result * 59 + ($oneOfType1 == null ? 43 : ((Object)$oneOfType1).hashCode());
            ObjectsLiteSource $oneOfType2 = this.oneOfType2;
            result = result * 59 + ($oneOfType2 == null ? 43 : ((Object)$oneOfType2).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "Image.OneOfSourceWrapper(oneOfType0=" + this.oneOfType0 + ", oneOfType1=" + this.oneOfType1 + ", oneOfType2=" + this.oneOfType2 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @VmmJsonDeserializer
        private static class OneOfSourceWrapperJsonDeserializer
        extends VmmOneOfDeserializer<OneOfSourceWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE0 = TYPE_FACTORY.constructType(UrlSource.class);
            private static final JavaType ONE_OF_TYPE1 = TYPE_FACTORY.constructType(VmDiskSource.class);
            private static final JavaType ONE_OF_TYPE2 = TYPE_FACTORY.constructType(ObjectsLiteSource.class);

            public OneOfSourceWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfSourceWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfSourceWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfSourceWrapper provided is null");
                }
                if (ONE_OF_TYPE0.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE2.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfSourceWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.vmm";
            }
        }
    }

    @JsonDeserialize(using=OneOfChecksumWrapperJsonDeserializer.class)
    public static class OneOfChecksumWrapper {
        @JsonIgnore
        private ImageSha1Checksum oneOfType0;
        @JsonIgnore
        private ImageSha256Checksum oneOfType1;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfChecksumWrapper() {
        }

        public OneOfChecksumWrapper(ImageSha1Checksum data) {
            this.oneOfType0 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfChecksumWrapper(ImageSha256Checksum data) {
            this.oneOfType1 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType0 != null && this.oneOfType0.get$objectType().equals(this.discriminator)) {
                return this.oneOfType0;
            }
            if (this.oneOfType1 != null && this.oneOfType1.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof ImageSha1Checksum) {
                this.oneOfType0 = (ImageSha1Checksum)value;
                this.discriminator = this.oneOfType0.get$objectType();
                this.$objectType = this.oneOfType0.get$objectType();
                return;
            }
            if (value instanceof ImageSha256Checksum) {
                this.oneOfType1 = (ImageSha256Checksum)value;
                this.discriminator = this.oneOfType1.get$objectType();
                this.$objectType = this.oneOfType1.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfChecksumWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfChecksumWrapper)) {
                return false;
            }
            OneOfChecksumWrapper other = (OneOfChecksumWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ImageSha1Checksum this$oneOfType0 = this.oneOfType0;
            ImageSha1Checksum other$oneOfType0 = other.oneOfType0;
            if (this$oneOfType0 == null ? other$oneOfType0 != null : !((Object)this$oneOfType0).equals(other$oneOfType0)) {
                return false;
            }
            ImageSha256Checksum this$oneOfType1 = this.oneOfType1;
            ImageSha256Checksum other$oneOfType1 = other.oneOfType1;
            if (this$oneOfType1 == null ? other$oneOfType1 != null : !((Object)this$oneOfType1).equals(other$oneOfType1)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfChecksumWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImageSha1Checksum $oneOfType0 = this.oneOfType0;
            result = result * 59 + ($oneOfType0 == null ? 43 : ((Object)$oneOfType0).hashCode());
            ImageSha256Checksum $oneOfType1 = this.oneOfType1;
            result = result * 59 + ($oneOfType1 == null ? 43 : ((Object)$oneOfType1).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "Image.OneOfChecksumWrapper(oneOfType0=" + this.oneOfType0 + ", oneOfType1=" + this.oneOfType1 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @VmmJsonDeserializer
        private static class OneOfChecksumWrapperJsonDeserializer
        extends VmmOneOfDeserializer<OneOfChecksumWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE0 = TYPE_FACTORY.constructType(ImageSha1Checksum.class);
            private static final JavaType ONE_OF_TYPE1 = TYPE_FACTORY.constructType(ImageSha256Checksum.class);

            public OneOfChecksumWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfChecksumWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfChecksumWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfChecksumWrapper provided is null");
                }
                if (ONE_OF_TYPE0.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfChecksumWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.vmm";
            }
        }
    }
}

